/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest.mappers;

import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import nl.avisi.confluence.plugins.gitplugin.exceptions.InjectableExceptionWrapper;
import nl.avisi.confluence.plugins.gitplugin.exceptions.RestError;

@Provider
public class InjectableExceptionWrapperMapper
implements ExceptionMapper<WebApplicationException> {
    @Nonnull
    private final I18nResolver i18nResolver;

    public InjectableExceptionWrapperMapper(@Nonnull I18nResolver i18nResolver) {
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
    }

    public Response toResponse(WebApplicationException exception) {
        if (exception.getCause() != null && exception.getCause().getClass().equals(InjectableExceptionWrapper.class)) {
            String message = this.i18nResolver.getText(exception.getCause().getCause().getMessage());
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new RestError(message)).build();
        }
        return exception.getResponse();
    }
}

