/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.factory;

import net.sourceforge.plantuml.salt.DataSource;
import net.sourceforge.plantuml.salt.Dictionary;
import net.sourceforge.plantuml.salt.Terminated;
import net.sourceforge.plantuml.salt.Terminator;
import net.sourceforge.plantuml.salt.element.Element;
import net.sourceforge.plantuml.salt.element.ElementTree;
import net.sourceforge.plantuml.salt.element.TableStrategy;
import net.sourceforge.plantuml.salt.factory.AbstractElementFactoryComplex;
import net.sourceforge.plantuml.ugraphic.UFont;

public class ElementFactoryTree
extends AbstractElementFactoryComplex {
    public ElementFactoryTree(DataSource dataSource, Dictionary dictionary) {
        super(dataSource, dictionary);
    }

    @Override
    public Terminated<Element> create() {
        if (!this.ready()) {
            throw new IllegalStateException();
        }
        String header = (String)((Terminated)this.getDataSource().next()).getElement();
        String textT = (String)((Terminated)this.getDataSource().next()).getElement();
        TableStrategy strategy = TableStrategy.DRAW_NONE;
        if (textT.length() == 2) {
            strategy = TableStrategy.fromChar(textT.charAt(1));
        }
        UFont font = UFont.byDefault(12);
        ElementTree result = new ElementTree(font, this.getDictionary(), strategy);
        boolean takeMe = true;
        while (!this.getDataSource().peek(0).getElement().equals("}")) {
            Terminated t = (Terminated)this.getDataSource().next();
            Terminator terminator = t.getTerminator();
            String s = (String)t.getElement();
            if (takeMe) {
                result.addEntry(s);
            } else {
                result.addCellToEntry(s);
            }
            takeMe = terminator == Terminator.NEWLINE;
        }
        Terminated next = (Terminated)this.getDataSource().next();
        return new Terminated<Element>(result, next.getTerminator());
    }

    @Override
    public boolean ready() {
        String text = this.getDataSource().peek(0).getElement();
        if (text.equals("{")) {
            String text1 = this.getDataSource().peek(1).getElement();
            if (text1.equals("T")) {
                return true;
            }
            if (text1.length() == 2 && text1.startsWith("T")) {
                char c = text1.charAt(1);
                return TableStrategy.fromChar(c) != null;
            }
            return false;
        }
        return false;
    }
}

