/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public enum ColorParam {
    background(HColorUtils.WHITE, true, ColorType.BACK),
    hyperlink(HColorUtils.BLUE),
    activityBackground(HColorUtils.MY_YELLOW, true, ColorType.BACK),
    activityBorder(HColorUtils.MY_RED, ColorType.LINE),
    classBackground(HColorUtils.MY_YELLOW, true, ColorType.BACK),
    classBorder(HColorUtils.MY_RED, ColorType.LINE),
    arrowHead(HColorUtils.MY_RED, null),
    stateBorder(HColorUtils.MY_RED, ColorType.LINE),
    noteBackground(HColorUtils.COL_FBFB77, true, ColorType.BACK),
    noteBorder(HColorUtils.MY_RED, ColorType.LINE),
    diagramBorder(null, ColorType.LINE),
    actorBackground(HColorUtils.MY_YELLOW, true, ColorType.BACK),
    actorBorder(HColorUtils.MY_RED, ColorType.LINE),
    sequenceGroupBodyBackground(HColorUtils.RED, true, ColorType.BACK),
    sequenceReferenceHeaderBackground(HColorUtils.COL_EEEEEE, true, ColorType.BACK),
    sequenceReferenceBackground(HColorUtils.WHITE, true, ColorType.BACK),
    sequenceLifeLineBorder(HColorUtils.MY_RED, ColorType.LINE),
    sequenceNewpageSeparator(HColorUtils.BLACK, ColorType.LINE),
    sequenceBoxBorder(HColorUtils.MY_RED, ColorType.LINE),
    iconPrivate(HColorUtils.COL_C82930),
    iconPrivateBackground(HColorUtils.COL_F24D5C),
    iconPackage(HColorUtils.COL_1963A0),
    iconPackageBackground(HColorUtils.COL_4177AF),
    iconProtected(HColorUtils.COL_B38D22),
    iconProtectedBackground(HColorUtils.COL_FFFF44),
    iconPublic(HColorUtils.COL_038048),
    iconPublicBackground(HColorUtils.COL_84BE84),
    iconIEMandatory(HColorUtils.BLACK),
    arrowLollipop(HColorUtils.WHITE),
    machineBackground(HColorUtils.WHITE),
    machineBorder(HColorUtils.BLACK, ColorType.LINE),
    requirementBackground(HColorUtils.WHITE),
    requirementBorder(HColorUtils.BLACK, ColorType.LINE),
    designedBackground(HColorUtils.WHITE),
    designedBorder(HColorUtils.BLACK, ColorType.LINE),
    domainBackground(HColorUtils.WHITE),
    domainBorder(HColorUtils.BLACK, ColorType.LINE),
    lexicalBackground(HColorUtils.WHITE),
    lexicalBorder(HColorUtils.BLACK, ColorType.LINE),
    biddableBackground(HColorUtils.WHITE),
    biddableBorder(HColorUtils.BLACK, ColorType.LINE);

    private final boolean isBackground;
    private final HColor defaultValue;
    private final ColorType colorType;

    private ColorParam(HColor defaultValue, ColorType colorType) {
        this(defaultValue, false, colorType);
    }

    private ColorParam(HColor defaultValue) {
        this(defaultValue, false, null);
    }

    private ColorParam() {
        this(null, false, null);
    }

    private ColorParam(boolean isBackground) {
        this(null, isBackground, null);
    }

    private ColorParam(HColor defaultValue, boolean isBackground, ColorType colorType) {
        this.isBackground = isBackground;
        this.defaultValue = defaultValue;
        this.colorType = colorType;
        if (colorType == ColorType.BACK && !isBackground) {
            System.err.println((Object)this);
            throw new IllegalStateException();
        }
    }

    protected boolean isBackground() {
        return this.isBackground;
    }

    public final HColor getDefaultValue() {
        return this.defaultValue;
    }

    public ColorType getColorType() {
        return this.colorType;
    }
}

