(function ($) {
    AJS.toInit(function () {
        $('.container').jstree({
            "core": {
                "animation": 0,
                "check_callback": true,
                "themes": {
                    "stripes": true,
                    "icons": false
                },
                'data': {
                    'url': function (node) {
                        var repo = $(this.element).data("repo");
                        var baseUrl = $(this.element).data("baseurl");
                        var branch =  encodeURIComponent($(this.element).data("branch"));
                        var commit = $(this.element).data("commit");
                        var path = $(this.element).data("path");
                        return node.id === '#' ?
                            baseUrl + repo + '/listDir?branch=' + branch + '&commitId=' + commit + '&baseurl=' + baseUrl + '&path=' + path
                            : baseUrl + repo + '/listDir?branch=' + branch + '&commitId=' + commit + '&baseurl=' + baseUrl
                    },
                    'data': function (node) {
                        return {path: node.id};
                    }
                }
            },
            "types": {
                "folder": {
                    "valid_children": ["default"]
                },
                "file": {
                    "valid_children": []
                }
            },
            "conditionalselect": function (node, event) {
                if (this.is_leaf(node)) {
                    if (event.ctrlKey || event.metaKey) {
                        window.open(event.target.href);
                    } else {
                        document.location.assign(event.target.href);
                    }
                }
            },
            "plugins": ["types", "wholerow", "state", "conditionalselect"]
        });
    });
})(jQuery.noConflict(true));
