/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import org.eclipse.jgit.lib.PersonIdent;
import org.gitective.core.filter.commit.CommitFilter;

public abstract class PersonFilter
extends CommitFilter {
    protected final String name;
    protected final String email;

    public PersonFilter(String name, String email) {
        this.name = name;
        this.email = email;
    }

    public PersonFilter(PersonIdent person) {
        if (person != null) {
            this.name = person.getName();
            this.email = person.getEmailAddress();
        } else {
            this.name = null;
            this.email = null;
        }
    }

    protected boolean match(PersonIdent ident) {
        if (ident == null) {
            return this.name == null && this.email == null;
        }
        if (this.name != null && !this.name.equals(ident.getName())) {
            return false;
        }
        return this.email == null || this.email.equals(ident.getEmailAddress());
    }
}

