/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest;

import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.user.EntityException;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.LicenseCheckBaseResource;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.SecurityService;
import nl.avisi.confluence.plugins.gitplugin.core.Group;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.license.LicenseChecker;

@Path(value="security/groups")
@Produces(value={"application/json"})
public class SecurityGroupResource
extends LicenseCheckBaseResource {
    private final SecurityService securityService;

    public SecurityGroupResource(@Nonnull SecurityService securityService, @Nonnull LicenseChecker licenseChecker) {
        super(licenseChecker);
        this.securityService = (SecurityService)Preconditions.checkNotNull((Object)securityService);
    }

    @GET
    public Response all() throws EntityException {
        return Response.ok(this.securityService.getAllGroups()).build();
    }

    @PUT
    @Path(value="{repositoryId}")
    @Consumes(value={"application/json"})
    @WebSudoRequired
    public Response setGroups(@PathParam(value="repositoryId") Repository repository, List<String> groups) {
        this.checkLicense();
        this.securityService.clearGroups(repository);
        this.securityService.addGroups(repository, groups);
        return Response.ok().build();
    }

    @GET
    @Path(value="{repositoryId}")
    @Consumes(value={"application/json"})
    public Response getGroups(@PathParam(value="repositoryId") Repository repository) {
        this.checkLicense();
        Collection groups = Collections2.transform((Collection)Lists.newArrayList((Object[])repository.getGroups()), (Function)new Function<Group, String>(){

            public String apply(Group input) {
                return input.getName();
            }
        });
        return Response.ok((Object)groups).build();
    }
}

