/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project.GanttConstraint;
import net.sourceforge.plantuml.project.LabelStrategy;
import net.sourceforge.plantuml.project.ToTaskDraw;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.core.TaskImpl;
import net.sourceforge.plantuml.project.draw.AbstractTaskDraw;
import net.sourceforge.plantuml.project.draw.FingerPrint;
import net.sourceforge.plantuml.project.draw.PathUtils;
import net.sourceforge.plantuml.project.draw.RectangleTask;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.graphic.Segment;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class TaskDrawRegular
extends AbstractTaskDraw {
    private final Day end;
    private final boolean oddStart;
    private final boolean oddEnd;
    private final Collection<Day> paused;
    private final Collection<GanttConstraint> constraints;
    private final ISkinParam skinParam;

    public TaskDrawRegular(TimeScale timeScale, Real y, String prettyDisplay, Day start, Day end, boolean oddStart, boolean oddEnd, ISkinParam skinParam, Task task, ToTaskDraw toTaskDraw, Collection<GanttConstraint> constraints, StyleBuilder styleBuilder, HColorSet colorSet) {
        super(timeScale, y, prettyDisplay, start, skinParam, task, toTaskDraw, styleBuilder, colorSet);
        this.skinParam = skinParam;
        this.constraints = constraints;
        this.end = end;
        this.oddStart = oddStart;
        this.oddEnd = oddEnd;
        this.paused = new TreeSet<Day>(((TaskImpl)task).getAllPaused());
        Day tmp = start;
        while (tmp.compareTo(end) <= 0) {
            int load = toTaskDraw.getDefaultPlan().getLoadAt(tmp);
            if (load == 0) {
                this.paused.add(tmp);
            }
            tmp = tmp.increment();
        }
    }

    @Override
    protected double getShapeHeight(StringBounder stringBounder) {
        Style style = this.getStyle();
        ClockwiseTopRightBottomLeft padding = style.getPadding();
        return padding.getTop() + this.getTitle().calculateDimension(stringBounder).getHeight() + padding.getBottom();
    }

    @Override
    public void drawTitle(UGraphic ug, LabelStrategy labelStrategy, double colTitles, double colBars) {
        TextBlock title = this.getTitle();
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dim = title.calculateDimension(stringBounder);
        Style style = this.getStyleSignature().getMergedStyle(this.getStyleBuilder());
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        ClockwiseTopRightBottomLeft padding = style.getPadding();
        ug = ug.apply(UTranslate.dy(margin.getTop() + padding.getTop()));
        if (labelStrategy.titleInFirstColumn()) {
            if (labelStrategy.rightAligned()) {
                title.drawU(ug.apply(UTranslate.dx(colTitles - dim.getWidth() - margin.getRight())));
            } else {
                title.drawU(ug.apply(UTranslate.dx(margin.getLeft())));
            }
            return;
        }
        if (labelStrategy.titleInLastColumn()) {
            title.drawU(ug.apply(UTranslate.dx(colBars + margin.getLeft())));
            return;
        }
        double pos1 = this.timeScale.getStartingPosition(this.start) + 6.0;
        double pos2 = this.timeScale.getEndingPosition(this.end) - 6.0;
        double pos = pos2 - pos1 > dim.getWidth() ? pos1 : this.getOutPosition(pos2);
        title.drawU(ug.apply(UTranslate.dx(pos)));
    }

    @Override
    protected TextBlock getTitle() {
        return Display.getWithNewlines(this.prettyDisplay).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    private double getOutPosition(double pos2) {
        if (this.isThereRightArrow()) {
            return pos2 + 18.0;
        }
        return pos2 + 8.0;
    }

    private boolean isThereRightArrow() {
        for (GanttConstraint constraint : this.constraints) {
            if (!constraint.isThereRightArrow(this.getTask())) continue;
            return true;
        }
        return false;
    }

    @Override
    StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.task);
    }

    @Override
    public void drawU(UGraphic ug) {
        double startPos = this.timeScale.getStartingPosition(this.start);
        this.drawNote(ug.apply(new UTranslate(startPos, this.getYNotePosition(ug.getStringBounder()))));
        ug = this.applyColors(ug);
        this.drawShape(ug);
    }

    private double getYNotePosition(StringBounder stringBounder) {
        Style style = this.getStyle();
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        return margin.getTop() + this.getShapeHeight(stringBounder) + margin.getBottom();
    }

    private void drawNote(UGraphic ug) {
        if (this.note == null) {
            return;
        }
        this.getOpaleNote().drawU(ug);
    }

    @Override
    public double getHeightMax(StringBounder stringBounder) {
        if (this.note == null) {
            return this.getFullHeightTask(stringBounder);
        }
        return this.getYNotePosition(stringBounder) + this.getOpaleNote().calculateDimension(stringBounder).getHeight();
    }

    private Opale getOpaleNote() {
        Style style = StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.note).getMergedStyle(this.getStyleBuilder());
        FontConfiguration fc = style.getFontConfiguration(this.skinParam.getThemeStyle(), this.getColorSet());
        HorizontalAlignment horizontalAlignment = style.value(PName.HorizontalAlignment).asHorizontalAlignment();
        Sheet sheet = Parser.build(fc, horizontalAlignment, this.skinParam, CreoleMode.FULL).createSheet(this.note);
        double padding = style.value(PName.Padding).asDouble();
        SheetBlock1 sheet1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, padding);
        HColor noteBackgroundColor = style.value(PName.BackGroundColor).asColor(this.skinParam.getThemeStyle(), this.getColorSet());
        HColor borderColor = style.value(PName.LineColor).asColor(this.skinParam.getThemeStyle(), this.getColorSet());
        double shadowing = style.value(PName.Shadowing).asDouble();
        return new Opale(shadowing, borderColor, noteBackgroundColor, sheet1, false, style.getStroke());
    }

    @Override
    public FingerPrint getFingerPrint(StringBounder stringBounder) {
        double h = this.getFullHeightTask(stringBounder);
        double startPos = this.timeScale.getStartingPosition(this.start);
        double endPos = this.timeScale.getEndingPosition(this.end);
        return new FingerPrint(startPos, this.getY(stringBounder).getCurrentValue(), endPos - startPos, h);
    }

    @Override
    public FingerPrint getFingerPrintNote(StringBounder stringBounder) {
        if (this.note == null) {
            return null;
        }
        Dimension2D dim = this.getOpaleNote().calculateDimension(stringBounder);
        double startPos = this.timeScale.getStartingPosition(this.start);
        return new FingerPrint(startPos, this.getY(stringBounder).getCurrentValue() + this.getYNotePosition(stringBounder), dim.getWidth(), dim.getHeight());
    }

    private UGraphic applyColors(UGraphic ug) {
        CenterBorderColor col = this.getColors();
        if (col != null && col.isOk()) {
            return col.apply(ug);
        }
        return ug.apply(this.getLineColor()).apply(this.getBackgroundColor().bg());
    }

    @Override
    public double getX1(TaskAttribute taskAttribute) {
        Style style = this.getStyleSignature().getMergedStyle(this.getStyleBuilder());
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        double startPos = taskAttribute == TaskAttribute.START ? this.timeScale.getStartingPosition(this.start) : this.timeScale.getStartingPosition(this.end) + margin.getLeft();
        return startPos;
    }

    @Override
    public double getX2(TaskAttribute taskAttribute) {
        Style style = this.getStyleSignature().getMergedStyle(this.getStyleBuilder());
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        double endPos = taskAttribute == TaskAttribute.START ? this.timeScale.getEndingPosition(this.start) : this.timeScale.getEndingPosition(this.end) - margin.getLeft();
        return endPos;
    }

    private void drawShape(UGraphic ug) {
        Style style = this.getStyleSignature().getMergedStyle(this.getStyleBuilder());
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        double startPos = this.timeScale.getStartingPosition(this.start) + margin.getLeft();
        double endPos = this.timeScale.getEndingPosition(this.end) - margin.getRight();
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        ug = ug.apply(UTranslate.dy(margin.getTop()));
        StringBounder stringBounder = ug.getStringBounder();
        double round = style.value(PName.RoundCorner).asDouble();
        ArrayList<Segment> off = new ArrayList<Segment>();
        for (Day pause : this.paused) {
            double x1 = this.timeScale.getStartingPosition(pause);
            double x2 = this.timeScale.getEndingPosition(pause);
            off.add(new Segment(x1, x2));
        }
        HColor backUndone = StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.undone).getMergedStyle(this.getStyleBuilder()).value(PName.BackGroundColor).asColor(this.skinParam.getThemeStyle(), this.getColorSet());
        RectangleTask rectangleTask = new RectangleTask(startPos, endPos, round, this.getCompletion(), off);
        rectangleTask.draw(ug, this.getShapeHeight(stringBounder), backUndone, this.oddStart, this.oddEnd);
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private void drawShapeOld(UGraphic ug) {
        Style style = this.getStyleSignature().getMergedStyle(this.getStyleBuilder());
        ClockwiseTopRightBottomLeft margin = style.getMargin();
        double startPos = this.timeScale.getStartingPosition(this.start) + margin.getLeft();
        double endPos = this.timeScale.getEndingPosition(this.end) - margin.getRight();
        double fullLength = endPos - startPos;
        if (fullLength < 3.0) {
            fullLength = 3.0;
        }
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        ug = ug.apply(UTranslate.dy(margin.getTop()));
        StringBounder stringBounder = ug.getStringBounder();
        double round = style.value(PName.RoundCorner).asDouble();
        if (this.oddStart && !this.oddEnd) {
            ug.apply(UTranslate.dx(startPos)).draw(PathUtils.UtoRight(fullLength, this.getShapeHeight(stringBounder), round));
        } else if (!this.oddStart && this.oddEnd) {
            ug.apply(UTranslate.dx(startPos)).draw(PathUtils.UtoLeft(fullLength, this.getShapeHeight(stringBounder), round));
        } else {
            URectangle full = new URectangle(fullLength, this.getShapeHeight(stringBounder)).rounded(round);
            if (this.getCompletion() == 100) {
                ug.apply(UTranslate.dx(startPos)).draw(full);
            } else {
                double partialLength = fullLength * (double)this.getCompletion() / 100.0;
                ug.apply(UTranslate.dx(startPos)).apply(HColorUtils.WHITE).apply(HColorUtils.WHITE.bg()).draw(full);
                if (partialLength > 2.0) {
                    URectangle partial = new URectangle(partialLength, this.getShapeHeight(stringBounder)).rounded(round);
                    ug.apply(UTranslate.dx(startPos)).apply(new HColorNone()).draw(partial);
                }
                if (partialLength > 10.0 && partialLength < fullLength - 10.0) {
                    URectangle patch = new URectangle(round, this.getShapeHeight(stringBounder));
                    ug.apply(UTranslate.dx(startPos)).apply(new HColorNone()).apply(UTranslate.dx(partialLength - round)).draw(patch);
                }
                ug.apply(UTranslate.dx(startPos)).apply(new HColorNone().bg()).draw(full);
            }
        }
        if (this.url != null) {
            ug.closeUrl();
        }
        Day begin = null;
        for (Day pause : this.paused) {
            if (this.paused.contains(pause.increment())) {
                if (begin != null) continue;
                begin = pause;
                continue;
            }
            if (begin == null) {
                this.drawPause(ug, pause, pause);
            } else {
                this.drawPause(ug, begin, pause);
            }
            begin = null;
        }
    }

    private void drawPause(UGraphic ug, Day start1, Day end) {
        double x1 = this.timeScale.getStartingPosition(start1);
        double x2 = this.timeScale.getEndingPosition(end);
        StringBounder stringBounder = ug.getStringBounder();
        URectangle small = new URectangle(x2 - x1 - 1.0, this.getShapeHeight(stringBounder) + 1.0);
        ULine line = ULine.hline(x2 - x1 - 1.0);
        ug = ug.apply(UTranslate.dx(x1 - 1.0));
        ug.apply(HColorUtils.WHITE).apply(HColorUtils.WHITE.bg()).draw(small);
        UGraphic ugLine = ug.apply(new UStroke(2.0, 3.0, 1.0));
        ugLine.draw(line);
        ugLine.apply(UTranslate.dy(this.getShapeHeight(stringBounder))).draw(line);
    }
}

