/**
 * Initialisation and logic for the panel.
 */
(function ($) {

    // Registers the tab when the Link Browser is created.
    AJS.bind("dialog-created.link-browser", function (e, linkBrowser) {

        var key = 'gitattachment',    // This panel's key
            $linkField,               // The jQueryfied link input element.
            $thisPanel,               // A reference to this panel
            $repositorySelect,
            $branchSelect,
            $commitSelect,
            $pathSelect,
            $folderSelect,
            $submitButton,
            tab;             // A reference to the tab

        tab = linkBrowser.tabs[key] = {

            // Called when the panel is created - register event handlers here
            createPanel: function (context) {
                $thisPanel = context.baseElement;
                $linkField = $thisPanel.find("input[name='destination']");
                $repositorySelect = $thisPanel.find("#repository-select");
                $branchSelect = $thisPanel.find("#branch-select");
                $commitSelect = $thisPanel.find("#commit-select");
                $pathSelect = $thisPanel.find("#file-path");
                $folderSelect = $thisPanel.find("#folder-path");
                $submitButton = $thisPanel.find("button");

                $thisPanel.find('input[name=contentId]').val(AJS.Confluence.getContentId());

                $repositorySelect.gitPluginRepositorySelect();

                $branchSelect.gitPluginBranchSelect({
                    repository: function () {
                        return $repositorySelect.val();
                    }
                });

                $commitSelect.gitPluginCommitSelect({
                    repository: function () {
                        return $repositorySelect.val();
                    },
                    branch: function () {
                        return $branchSelect.val();
                    }
                });

                $pathSelect.gitRepositoryFileAutocompleter({
                    repository: function () {
                        return $repositorySelect.val();
                    },
                    branch: function () {
                        return $branchSelect.val();
                    }
                });

                $folderSelect.gitRepositoryFolderAutocompleter({
                    repository: function () {
                        return $repositorySelect.val();
                    },
                    branch: function () {
                        return $branchSelect.val();
                    },
                    commit: function () {
                        return $commitSelect.val();
                    },

                });

                $form = $thisPanel.find("form.aui");
                $form.on("submit", function (e) {
                    e.preventDefault();
                    var formData = $form.serializeObject();
                    AJS.$.ajax({
                        url: AJS.contextPath() + "/rest/git-plugin/1.0/attachments",
                        type: "POST",
                        contentType: 'application/json',
                        data: JSON.stringify(formData),
                        error: function (data) {
                            if (data.status === 409) {
                                AJS.messages.error("#insert-git-attachment-dialog-messages", {
                                    title: AJS.I18n.getText("gitplugin.attachment.dialog.notification.filename.error.title"),
                                    body: "<p>" + AJS.I18n.getText("gitplugin.attachment.dialog.notification.filename.error.body") + "</p>",
                                    closeable: false
                                });
                            } else {
                                AJS.$("#insert-git-attachment-dialog-messages").empty();
                                AJS.messages.error("#insert-git-attachment-dialog-messages", {
                                    title: AJS.I18n.getText("gitplugin.attachment.dialog.notification.error.title"),
                                    body: "<p>" + AJS.I18n.getText("gitplugin.attachment.dialog.notification.error.body", formData.path) + "</p>",
                                    closeable: false
                                });
                            }
                        },
                        success: function (attachmentId) {
                            var linkObj = Confluence.Link.fromREST({
                                type: 'attachment',
                                id: attachmentId,
                                title: $pathSelect.val()
                            });
                            linkObj.attrs["data-linked-resource-container-id"] = AJS.Meta.get('content-id');
                            linkBrowser.setLink(linkObj);
                            linkBrowser.focusLinkText();
                            linkBrowser.submit();
                        }
                    });
                });

            },

            // Called when the panel is selected
            onSelect: function () {
                linkBrowser.moveLocationPanel($thisPanel.find("#git-attachment-link-text"));
            },

            // Called when this panel is no longer selected
            onDeselect: function () {
                linkBrowser.restoreLocationPanel();
            },

            // Called when the submit button is clicked, before the location is retrieved
            preSubmit: function () {
            },

            // Called before the dialog opens to determine which tab to highlight
            handlesLink: function (linkObj) {
                console.log("handles link");
                // return true if the link should be cause this panel to be selected
                return false;
            }
        };
    });
})(AJS.$);
