/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.validation;

import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.AddServer;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.ServerService;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.core.ServerAuthentication;
import nl.avisi.confluence.plugins.gitplugin.core.ServerInfo;
import nl.avisi.confluence.plugins.gitplugin.exceptions.ConstraintViolationException;
import nl.avisi.confluence.plugins.gitplugin.exceptions.ValidationError;
import nl.avisi.confluence.plugins.gitplugin.validation.ServerAuthenticationValidator;
import nl.avisi.confluence.plugins.gitplugin.validation.ServerHostValidator;
import nl.avisi.confluence.plugins.gitplugin.validation.Validator;

public class ServerValidator
extends Validator {
    private final ServerService serverService;
    private final ServerAuthenticationValidator serverAuthenticationValidator;
    private final ServerHostValidator serverHostValidator;
    private final I18nResolver i18nResolver;

    public ServerValidator(ServerService serverService, I18nResolver i18nResolver, ServerAuthenticationValidator serverAuthenticationValidator, ServerHostValidator serverHostValidator) {
        super(i18nResolver);
        this.serverService = serverService;
        this.i18nResolver = i18nResolver;
        this.serverAuthenticationValidator = serverAuthenticationValidator;
        this.serverHostValidator = serverHostValidator;
    }

    public void validateForSave(AddServer addServer) {
        Set<ValidationError> validationErrors = this.isValid(addServer, false);
        if (!validationErrors.isEmpty()) {
            throw new ConstraintViolationException(validationErrors);
        }
    }

    public void validateForUpdate(AddServer addServer) {
        Set<ValidationError> validationErrors = this.isValid(addServer, true);
        if (!validationErrors.isEmpty()) {
            throw new ConstraintViolationException(validationErrors);
        }
    }

    public Set<ValidationError> validateAndGetValidationErrorsForSave(AddServer addServer) {
        return this.isValid(addServer, false);
    }

    public Set<ValidationError> validateAndGetValidationErrorsForUpdate(AddServer addServer) {
        return this.isValid(addServer, true);
    }

    private Set<ValidationError> isValid(AddServer addServer, boolean update) {
        if (addServer == null) {
            throw new IllegalArgumentException("AddServer should not be null");
        }
        HashSet validationErrors = Sets.newHashSet();
        validationErrors.addAll(this.validateFields(addServer, update));
        validationErrors.addAll(this.validateServerInfo(addServer));
        validationErrors.addAll(this.validateServerAuthentication(addServer));
        return validationErrors;
    }

    private Set<ValidationError> validateFields(AddServer addServer, boolean update) {
        HashSet validationErrors = Sets.newHashSet((Object[])new Optional[]{this.checkId(addServer, update), this.checkName(addServer), this.validateUniqueHost(addServer)});
        return this.createValidationErrorSet(validationErrors);
    }

    private Optional<ValidationError> checkId(AddServer addServer, boolean update) {
        if (update) {
            return this.validateNotNull(addServer.getId(), "name");
        }
        return Optional.empty();
    }

    private Optional<ValidationError> checkName(AddServer addServer) {
        Optional<ValidationError> notNull = this.validateNotNull(addServer.getName(), "name");
        Optional<ValidationError> notBlank = this.validateNotBlank(addServer.getName(), "name");
        if (notNull.isPresent()) {
            return notNull;
        }
        if (notBlank.isPresent()) {
            return notBlank;
        }
        return Optional.empty();
    }

    private Set<ValidationError> validateServerInfo(AddServer addServer) {
        ServerInfo serverInfo = addServer.getServerInfo();
        return this.serverHostValidator.validate(serverInfo);
    }

    private Set<ValidationError> validateServerAuthentication(AddServer addServer) {
        ServerAuthentication serverAuthentication = addServer.getServerAuthentication();
        return this.serverAuthenticationValidator.validate(serverAuthentication);
    }

    private Optional<ValidationError> validateUniqueHost(AddServer addServer) {
        String errorMessage = this.i18nResolver.getText("gitplugin.validation.constraints.Host.unique.message");
        Optional<ValidationError> notNull = this.validateNotNull(addServer.getServerInfo(), "serverInfo");
        if (notNull.isPresent()) {
            return notNull;
        }
        Optional<Server> serverOptional = this.serverService.getByHost(addServer.getServerInfo().getHost());
        if (serverOptional.isPresent()) {
            Server server = serverOptional.get();
            if (addServer.getId() == null) {
                return Optional.of(new ValidationError("serverInfo", errorMessage));
            }
            if (addServer.getId().intValue() != server.getID()) {
                return Optional.of(new ValidationError("serverInfo", errorMessage));
            }
        }
        return Optional.empty();
    }
}

