/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.validation;

import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.core.ServerInfo;
import nl.avisi.confluence.plugins.gitplugin.exceptions.ValidationError;
import nl.avisi.confluence.plugins.gitplugin.validation.Validator;

public class ServerHostValidator
extends Validator {
    public ServerHostValidator(I18nResolver i18nResolver) {
        super(i18nResolver);
    }

    public Set<ValidationError> validate(ServerInfo serverInfo) {
        HashSet validationErrors = serverInfo != null ? Sets.newHashSet((Object[])new Optional[]{this.validateConnectionProtocol(serverInfo), this.validateHost(serverInfo)}) : Sets.newHashSet((Object[])new Optional[]{this.validateNotNull(serverInfo, "serverInfo")});
        return this.createValidationErrorSet(validationErrors);
    }

    private Optional<ValidationError> validateConnectionProtocol(ServerInfo serverInfo) {
        Server.ConnectionProtocol connectionProtocol = serverInfo.getProtocol();
        Optional<ValidationError> notNull = this.validateNotNull((Object)connectionProtocol, "serverInfo");
        if (notNull.isPresent()) {
            return notNull;
        }
        return this.validateProtocol(connectionProtocol);
    }

    private Optional<ValidationError> validateHost(ServerInfo serverInfo) {
        String host = serverInfo.getHost();
        Optional<ValidationError> notNull = this.validateNotNull(host, "serverInfo");
        if (notNull.isPresent()) {
            return notNull;
        }
        Optional<ValidationError> notBlank = this.validateNotBlank(host, "serverInfo");
        if (notBlank.isPresent()) {
            return notBlank;
        }
        return this.validateHost(host);
    }
}

