/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.validation;

import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.RestRepository;
import nl.avisi.confluence.plugins.gitplugin.exceptions.ConstraintViolationException;
import nl.avisi.confluence.plugins.gitplugin.exceptions.ValidationError;
import nl.avisi.confluence.plugins.gitplugin.validation.Validator;

public class RepositoryValidator
extends Validator {
    public RepositoryValidator(I18nResolver i18nResolver) {
        super(i18nResolver);
    }

    public void validate(RestRepository restRepository) {
        Set<ValidationError> validationErrors = this.isValid(restRepository);
        if (!validationErrors.isEmpty()) {
            throw new ConstraintViolationException(validationErrors);
        }
    }

    public Set<ValidationError> validateAndGetValidationErrors(RestRepository restRepository) {
        return this.isValid(restRepository);
    }

    private Set<ValidationError> isValid(RestRepository restRepository) {
        HashSet validationErrors = Sets.newHashSet((Object[])new Optional[]{this.checkName(restRepository), this.checkPath(restRepository)});
        return this.createValidationErrorSet(validationErrors);
    }

    private Optional<ValidationError> checkName(RestRepository restRepository) {
        Optional<ValidationError> notNull = this.validateNotNull(restRepository.getName(), "name");
        if (notNull.isPresent()) {
            return notNull;
        }
        return this.validateNotBlank(restRepository.getName(), "name");
    }

    private Optional<ValidationError> checkPath(RestRepository restRepository) {
        Optional<ValidationError> notNull = this.validateNotNull(restRepository.getPath(), "path");
        if (!notNull.isPresent()) {
            Optional<ValidationError> notBlank = this.validateNotBlank(restRepository.getPath(), "path");
            if (notBlank.isPresent()) {
                return notBlank;
            }
            return this.validateRegularExpression(restRepository.getPath(), "^[\\/:].+$");
        }
        return notNull;
    }
}

