/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.git;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.Optional;
import javax.annotation.Nonnull;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.ServerService;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.git.GitPluginSshCredentialsProvider;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.CredentialsProviderUserInfo;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.util.FS;

public class CredentialsConfigurationSessionFactory
extends JschConfigSessionFactory {
    private final GitPluginSshCredentialsProvider gitPluginSshCredentialsProvider;
    private final ServerService serverService;

    public CredentialsConfigurationSessionFactory(@Nonnull GitPluginSshCredentialsProvider gitPluginSshCredentialsProvider, @Nonnull ServerService serverService) {
        this.gitPluginSshCredentialsProvider = (GitPluginSshCredentialsProvider)Preconditions.checkNotNull((Object)gitPluginSshCredentialsProvider);
        this.serverService = (ServerService)Preconditions.checkNotNull((Object)serverService);
    }

    @Override
    protected void configure(OpenSshConfig.Host hc, Session session) {
        CredentialsProviderUserInfo userInfo = new CredentialsProviderUserInfo(session, this.gitPluginSshCredentialsProvider);
        session.setUserInfo(userInfo);
        session.setConfig("StrictHostKeyChecking", "no");
    }

    @Override
    protected JSch getJSch(OpenSshConfig.Host host, FS fileSystem) throws JSchException {
        JSch jSch = this.createDefaultJsch(host, fileSystem);
        Optional<Server> optional = this.serverService.getByHost(host.getHostName());
        if (!optional.isPresent()) {
            return jSch;
        }
        Server server = optional.get();
        if (StringUtils.isBlank((String)server.getSshKey())) {
            return jSch;
        }
        byte[] password = this.getPassword(server);
        String sshKey = this.getSshKeyPath(fileSystem, server);
        jSch.removeAllIdentity();
        jSch.addIdentity(sshKey, password);
        return jSch;
    }

    protected JSch createDefaultJsch(OpenSshConfig.Host host, FS fileSystem) throws JSchException {
        return super.getJSch(host, fileSystem);
    }

    private String getSshKeyPath(FS fileSystem, Server server) throws JSchException {
        String sshKey = server.getSshKey();
        if (StringUtils.startsWith((String)sshKey, (String)"~")) {
            sshKey = new File(fileSystem.userHome(), sshKey.replace("~/", "")).getAbsolutePath();
        }
        if (!new File(sshKey).exists()) {
            throw new JSchException(String.format("Could not find the SSH key file on %s", sshKey));
        }
        return sshKey;
    }

    private byte[] getPassword(Server server) {
        byte[] password = StringUtils.isBlank((String)server.getPassword()) ? new byte[]{} : server.getPassword().getBytes(Charsets.UTF_8);
        return password;
    }
}

