/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.flexmark.extentions;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.LinkResolverBasicContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.html.MutableAttributes;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomLinkResolver
implements LinkResolver,
LinkResolverFactory {
    private final String baseUrl;
    private final Map<String, String> parameters;

    CustomLinkResolver(SettingsManager settingsManager, Map<String, String> parameters, int repositoryId, String branch) {
        String instanceUrl = settingsManager.getGlobalSettings().getBaseUrl();
        this.baseUrl = CustomLinkResolver.attachmentUrlBuilder(instanceUrl, repositoryId, branch);
        this.parameters = parameters;
    }

    @Override
    @NotNull
    public ResolvedLink resolveLink(@NotNull Node node, @NotNull LinkResolverBasicContext linkResolverBasicContext, @NotNull ResolvedLink link) {
        if (node instanceof Image || node instanceof Reference) {
            String url = link.getUrl();
            MutableAttributes attributes = link.getNonNullAttributes().toMutable();
            attributes.addValue("style", "max-width: 100%;");
            if (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://") || url.startsWith("sftp://") || url.startsWith("file:/")) {
                return new ResolvedLink(link.getLinkType(), url, attributes, LinkStatus.VALID);
            }
            if (url.startsWith("/")) {
                return new ResolvedLink(link.getLinkType(), this.baseUrl + url.substring(1), attributes, LinkStatus.VALID);
            }
            if (!url.matches("^(?:[a-z]+:|#|\\?)")) {
                if (url.startsWith("./")) {
                    url = url.substring(2);
                }
                Object pathFromRoot = "";
                if (Paths.get(this.parameters.get("path"), new String[0]).getParent() != null) {
                    pathFromRoot = Paths.get(this.parameters.get("path"), new String[0]).getParent().toString() + "/";
                }
                return new ResolvedLink(link.getLinkType(), this.baseUrl + (String)pathFromRoot + url, attributes, LinkStatus.VALID);
            }
        }
        return link;
    }

    public static String attachmentUrlBuilder(String instanceUrl, int repositoryId, String branch) {
        return instanceUrl + "/rest/git-plugin/1.0/repositories/" + repositoryId + "/attachment?branch=" + branch + "&path=";
    }

    @Override
    @Nullable
    public Set<Class<?>> getAfterDependents() {
        return null;
    }

    @Override
    @Nullable
    public Set<Class<?>> getBeforeDependents() {
        return null;
    }

    @Override
    public boolean affectsGlobalScope() {
        return false;
    }

    @Override
    @NotNull
    public LinkResolver apply(@NotNull LinkResolverBasicContext linkResolverBasicContext) {
        return this;
    }
}

