/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.LicenseCheckBaseResource;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.RestGitAttachment;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.RestRepository;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryService;
import nl.avisi.confluence.plugins.gitplugin.core.GitAttachment;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.exceptions.RestError;
import nl.avisi.confluence.plugins.gitplugin.git.exception.ListRepositoryBranchesException;
import nl.avisi.confluence.plugins.gitplugin.git.exception.RepositoryInitializationException;
import nl.avisi.confluence.plugins.gitplugin.git.manager.GitRepositoryManager;
import nl.avisi.confluence.plugins.gitplugin.license.LicenseChecker;
import nl.avisi.confluence.plugins.gitplugin.validation.RepositoryValidator;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.Tika;
import org.eclipse.jgit.api.errors.GitAPIException;

@Path(value="/repositories")
public class RepositoryResource
extends LicenseCheckBaseResource {
    private final RepositoryService repositoryService;
    private final GitRepositoryManager gitRepositoryManager;
    private final AttachmentManager attachmentManager;
    private final I18nResolver i18nResolver;
    private final RepositoryValidator repositoryValidator;
    private Tika tika;

    public RepositoryResource(@Nonnull RepositoryService repositoryService, @Nonnull GitRepositoryManager gitRepositoryManager, @Nonnull LicenseChecker licenseChecker, @Nonnull AttachmentManager attachmentManager, @Nonnull I18nResolver i18nResolver, @Nonnull RepositoryValidator repositoryValidator) {
        super(licenseChecker);
        this.gitRepositoryManager = (GitRepositoryManager)Preconditions.checkNotNull((Object)gitRepositoryManager);
        this.attachmentManager = (AttachmentManager)Preconditions.checkNotNull((Object)attachmentManager);
        this.repositoryService = (RepositoryService)Preconditions.checkNotNull((Object)repositoryService);
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
        this.repositoryValidator = (RepositoryValidator)Preconditions.checkNotNull((Object)repositoryValidator);
        this.tika = new Tika();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getRepositories() {
        this.checkLicense();
        Collection<Repository> repositories = this.repositoryService.getRepositories(true);
        return Response.ok(RestRepository.collection(repositories)).build();
    }

    @GET
    @Path(value="{repositoryId}")
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="repositoryId") Repository repository) {
        this.checkLicense();
        return Response.ok((Object)new RestRepository(repository)).build();
    }

    @PUT
    @Path(value="{repositoryId}")
    @Produces(value={"application/json"})
    @WebSudoRequired
    public Response update(RestRepository restRepository, @PathParam(value="repositoryId") Repository repository) throws RepositoryInitializationException {
        this.checkLicense();
        this.repositoryValidator.validate(restRepository);
        this.repositoryService.update(repository, restRepository.getName(), restRepository.getPath());
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{repositoryId}")
    @Produces(value={"application/json"})
    @WebSudoRequired
    public Response delete(@PathParam(value="repositoryId") Repository repository) {
        this.checkLicense();
        int attachmentsAmount = repository.getGitAttachments().length;
        if (attachmentsAmount > 0) {
            return Response.status((int)422).entity((Object)new RestError(this.i18nResolver.getText("gitplugin.repository.linkedattachments", new Serializable[]{Integer.valueOf(attachmentsAmount)}))).build();
        }
        this.repositoryService.delete(repository.getID());
        return Response.ok().build();
    }

    @POST
    @Path(value="{serverId}")
    @Consumes(value={"application/json"})
    @WebSudoRequired
    public Response save(RestRepository restRepository, @PathParam(value="serverId") Server server) throws RepositoryInitializationException {
        this.checkLicense();
        this.repositoryValidator.validate(restRepository);
        Repository createdRepository = this.repositoryService.create(server, restRepository.getName(), restRepository.getPath());
        return Response.ok((Object)new RestRepository(createdRepository)).build();
    }

    @GET
    @Path(value="{repositoryId}/branches-and-tags-autocomplete")
    @Produces(value={"application/json"})
    public Response allBranches(@PathParam(value="repositoryId") Repository repository) throws ListRepositoryBranchesException {
        this.checkLicense();
        JSONObject branchObject = new JSONObject();
        JSONObject tagObject = new JSONObject();
        JSONArray branchArrayObj = new JSONArray();
        JSONArray tagArrayObj = new JSONArray();
        JSONArray combined = new JSONArray();
        JSONObject outerObj = new JSONObject();
        if (!this.repositoryService.getBranches(repository).isEmpty()) {
            branchObject.put("text", (Object)"Branches");
            for (String repositoryName : this.repositoryService.getBranches(repository)) {
                branchArrayObj.put((Object)new JSONObject().put("id", (Object)repositoryName).put("text", (Object)this.gitRepositoryManager.normalizeRef(repositoryName)));
            }
            branchObject.put("children", (Object)branchArrayObj);
            combined.put((Object)branchObject);
        }
        if (!this.repositoryService.getTags(repository).isEmpty()) {
            tagObject.put("text", (Object)"Tags");
            for (String tagName : this.repositoryService.getTags(repository)) {
                tagArrayObj.put((Object)new JSONObject().put("id", (Object)tagName).put("text", (Object)this.gitRepositoryManager.normalizeRef(tagName)));
            }
            tagObject.put("children", (Object)tagArrayObj);
            combined.put((Object)tagObject);
        }
        outerObj.put("results", (Object)combined);
        return Response.ok((Object)outerObj.toString()).build();
    }

    @GET
    @Path(value="{repositoryId}/commits")
    @Produces(value={"application/json"})
    public Response allCommits(@PathParam(value="repositoryId") Repository repository, @QueryParam(value="branch") String branch, @QueryParam(value="term") String term, @QueryParam(value="itemsPerPage") int maxCount, @QueryParam(value="page") int start) throws IOException, GitAPIException {
        this.checkLicense();
        return Response.ok(this.repositoryService.getCommits(repository, branch, term, maxCount, start)).build();
    }

    @GET
    @Path(value="{repositoryId}/files")
    @Produces(value={"application/json"})
    public Response autoComplete(@PathParam(value="repositoryId") Repository repository, @QueryParam(value="branch") String branch, @QueryParam(value="commitId") String commitId, @QueryParam(value="path") String path) throws IOException {
        this.checkLicense();
        return Response.ok(this.repositoryService.listFilesInDirectory(repository, branch, commitId, path)).build();
    }

    @GET
    @Path(value="{repositoryId}/folders")
    @Produces(value={"application/json"})
    public Response autoCompleteFolder(@PathParam(value="repositoryId") Repository repository, @QueryParam(value="branch") String branch, @QueryParam(value="commitId") String commitId, @QueryParam(value="path") String path) throws IOException {
        this.checkLicense();
        Collection<String> temp = this.repositoryService.listFilesInDirectory(repository, branch, commitId, path);
        Set result = temp.stream().filter(x -> x.endsWith("/")).collect(Collectors.toSet());
        return Response.ok(result).build();
    }

    @GET
    @Path(value="{repositoryId}/listDir")
    @Produces(value={"application/json"})
    public Response listDir(@PathParam(value="repositoryId") Repository repository, @QueryParam(value="branch") String branch, @QueryParam(value="commitId") String commitId, @QueryParam(value="path") String path, @QueryParam(value="baseurl") String baseUrl) throws IOException {
        this.checkLicense();
        branch = URLDecoder.decode(branch, "UTF-8");
        path = StringEscapeUtils.unescapeHtml((String)path);
        List sList = (List)this.repositoryService.listFilesInDirectory(repository, branch, commitId, path);
        JSONArray outerObj = new JSONArray();
        for (String s : sList) {
            JSONObject nodeObject;
            String HTMLEncodedS = StringEscapeUtils.escapeHtml((String)s);
            if (s.endsWith("/")) {
                nodeObject = new JSONObject();
                nodeObject.put("id", (Object)HTMLEncodedS);
                nodeObject.put("text", (Object)StringEscapeUtils.escapeHtml((String)s.replaceAll("^(.*\\/)*(.*\\/)", "$2")));
                nodeObject.put("type", (Object)"folder");
                nodeObject.put("children", true);
                outerObj.put((Object)nodeObject);
                continue;
            }
            nodeObject = new JSONObject();
            nodeObject.put("id", (Object)HTMLEncodedS);
            nodeObject.put("text", (Object)("<a href=" + this.attachmentUrlBuilder(repository, baseUrl, branch, s) + " target=\"_blank\">" + StringEscapeUtils.escapeHtml((String)(s.contains("/") & !s.endsWith("/") ? StringUtils.substringAfterLast((String)s, (String)"/") : s)) + "</a>"));
            nodeObject.put("type", (Object)"file");
            outerObj.put((Object)nodeObject);
        }
        return Response.ok((Object)outerObj.toString()).build();
    }

    private String attachmentUrlBuilder(Repository repository, String baseUrl, String branch, String path) {
        UriBuilder builder = UriBuilder.fromPath((String)(baseUrl + repository.getID())).path("/attachment").queryParam("branch", new Object[]{branch}).queryParam("path", new Object[]{path});
        return builder.build(new Object[]{branch, path}).toString();
    }

    @GET
    @Path(value="{repositoryId}/attachment")
    @Produces(value={"image/png", "image/jpeg", "image/gif"})
    public Response attachmentInputStream(@PathParam(value="repositoryId") Repository repository, @QueryParam(value="branch") String branch, @QueryParam(value="commitId") String commitId, @QueryParam(value="path") String path) throws IOException {
        this.checkLicense();
        String mimeType = this.tika.detect(path);
        String response = mimeType.toLowerCase().split("/")[0].equals("image") ? mimeType : "text/plain";
        return Response.ok((Object)this.repositoryService.getInputStream(repository, branch, commitId, path), (String)response).build();
    }

    @GET
    @Path(value="{repositoryId}/attachments")
    @Produces(value={"application/json"})
    public Response attachments(@PathParam(value="repositoryId") Repository repository) {
        ArrayList attachments = Lists.newArrayList((Object[])repository.getGitAttachments());
        List restAttachments = attachments.stream().map(this::gitAttachmentToRestGitAttachment).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return Response.ok(restAttachments).build();
    }

    private Optional<RestGitAttachment> gitAttachmentToRestGitAttachment(GitAttachment attachment) {
        Attachment confluenceAttachment = this.attachmentManager.getAttachment(attachment.getAttachmentId());
        if (confluenceAttachment != null) {
            return Optional.of(new RestGitAttachment(attachment, confluenceAttachment));
        }
        return Optional.empty();
    }

    @GET
    @Path(value="by-path")
    @Produces(value={"application/json"})
    public Response repositoryByPath(@QueryParam(value="repositoryPath") String repositoryPath) {
        this.checkLicense();
        List<Repository> repositories = this.repositoryService.findByPath(repositoryPath);
        if (repositories.size() == 1) {
            Repository repository = repositories.get(0);
            return Response.ok((Object)repository.getID()).build();
        }
        if (repositories.size() == 0) {
            return Response.status((int)404).build();
        }
        return Response.status((int)500).build();
    }

    @GET
    @Path(value="{repositoryId}/collect-macro-information")
    @Produces(value={"application/json"})
    public Response collectMacroInformation(@PathParam(value="repositoryId") Repository repository, @QueryParam(value="uriSource") String uriSource) throws ListRepositoryBranchesException, IOException, GitAPIException {
        this.checkLicense();
        return Response.ok((Object)this.repositoryService.getGitInformation(repository, uriSource)).build();
    }

    @POST
    @Path(value="{repositoryId}/actions/archive")
    @Produces(value={"application/json"})
    public Response archive(@PathParam(value="repositoryId") Repository repository) {
        this.repositoryService.archive(repository.getID());
        return Response.ok().build();
    }

    @POST
    @Path(value="{repositoryId}/actions/unarchive")
    @Produces(value={"application/json"})
    public Response unarchive(@PathParam(value="repositoryId") Repository repository) {
        this.repositoryService.unarchive(repository.getID());
        return Response.ok().build();
    }
}

