/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.attachment.listener;

import com.atlassian.confluence.event.events.content.attachment.AttachmentRemoveEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import java.util.Optional;
import nl.avisi.confluence.plugins.gitplugin.attachment.dao.GitAttachmentDao;
import nl.avisi.confluence.plugins.gitplugin.core.GitAttachment;
import org.springframework.beans.factory.DisposableBean;

public class AttachmentEventListener
implements DisposableBean {
    private final EventPublisher eventPublisher;
    private final GitAttachmentDao gitAttachmentDao;

    public AttachmentEventListener(EventPublisher eventPublisher, GitAttachmentDao gitAttachmentDao) {
        this.eventPublisher = eventPublisher;
        this.gitAttachmentDao = gitAttachmentDao;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onAttachmentRemoved(AttachmentRemoveEvent attachmentRemoveEvent) {
        Optional<GitAttachment> optional = this.gitAttachmentDao.get(attachmentRemoveEvent.getAttachment().getId());
        if (optional.isPresent()) {
            this.gitAttachmentDao.delete(optional.get());
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

