/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.attachment.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import nl.avisi.confluence.plugins.gitplugin.attachment.dao.GitAttachmentDao;
import nl.avisi.confluence.plugins.gitplugin.core.GitAttachment;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;

public class ActiveObjectsGitAttachmentDao
implements GitAttachmentDao {
    private final ActiveObjects activeObjects;

    public ActiveObjectsGitAttachmentDao(@Nonnull ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    @Override
    public GitAttachment save(@Nonnull Repository repository, @Nonnull String branch, long attachmentId, @Nonnull String filePath, @Nonnull String commitId) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)branch);
        Preconditions.checkNotNull((Object)attachmentId);
        Preconditions.checkNotNull((Object)filePath);
        Preconditions.checkNotNull((Object)commitId);
        GitAttachment gitAttachment = (GitAttachment)this.activeObjects.create(GitAttachment.class, new DBParam[]{new DBParam("REPOSITORY_ID", (Object)repository), new DBParam("BRANCH", (Object)branch), new DBParam("ATTACHMENT_ID", (Object)attachmentId), new DBParam("FILE_PATH", (Object)filePath), new DBParam("COMMIT_ID", (Object)commitId)});
        gitAttachment.save();
        return gitAttachment;
    }

    @Override
    public void update(GitAttachment gitAttachment) {
        gitAttachment.save();
    }

    @Override
    public Optional<GitAttachment> get(long attachmentId) {
        Preconditions.checkNotNull((Object)attachmentId);
        GitAttachment[] gitAttachments = (GitAttachment[])this.activeObjects.find(GitAttachment.class, Query.select().where("ATTACHMENT_ID = ?", new Object[]{attachmentId}).limit(1));
        if (gitAttachments.length == 1) {
            return Optional.of(gitAttachments[0]);
        }
        return Optional.empty();
    }

    @Override
    public void delete(@Nonnull GitAttachment gitAttachment) {
        Preconditions.checkNotNull((Object)gitAttachment);
        this.activeObjects.delete(new RawEntity[]{gitAttachment});
    }
}

