/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.PlainDiagram;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class PSystemSkinparameterList
extends PlainDiagram {
    public PSystemSkinparameterList(UmlSource source) {
        super(source);
    }

    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) throws IOException {
        final List<TextBlock> cols = PSystemSkinparameterList.getCols(this.getDonors(), 5);
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                StringBounder stringBounder = ug.getStringBounder();
                double x = 0.0;
                double y = 0.0;
                for (TextBlock tb : cols) {
                    Dimension2D dim = tb.calculateDimension(stringBounder);
                    tb.drawU(ug.apply(UTranslate.dx(x)));
                    x += dim.getWidth() + 10.0;
                    y = Math.max(y, dim.getHeight());
                }
            }
        };
    }

    public static List<TextBlock> getCols(List<String> lines, int nbCol) throws IOException {
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        int maxLine = (lines.size() + (nbCol - 1)) / nbCol;
        for (int i = 0; i < lines.size(); i += maxLine) {
            List<String> current = lines.subList(i, Math.min(lines.size(), i + maxLine));
            result.add(GraphicStrings.createBlackOnWhite(current));
        }
        return result;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> lines = new ArrayList<String>(SkinParam.getPossibleValues());
        return lines;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Parameters)");
    }

    public static PSystemSkinparameterList create(UmlSource source) {
        return new PSystemSkinparameterList(source);
    }
}

