/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.awt.geom.Dimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class LinkConstraint {
    private final Link link1;
    private final Link link2;
    private final Display display;
    private double x1;
    private double y1;
    private double x2;
    private double y2;

    public LinkConstraint(Link link1, Link link2, Display display) {
        this.link1 = link1;
        this.link2 = link2;
        this.display = display;
    }

    public void setPosition(Link link, Point2D pt) {
        if (link == this.link1) {
            this.x1 = pt.getX();
            this.y1 = pt.getY();
        } else if (link == this.link2) {
            this.x2 = pt.getX();
            this.y2 = pt.getY();
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void drawMe(UGraphic ug, ISkinParam skinParam) {
        if (this.x1 == 0.0 && this.y1 == 0.0) {
            return;
        }
        if (this.x2 == 0.0 && this.y2 == 0.0) {
            return;
        }
        ug = ug.apply(HColorUtils.BLACK);
        ULine line = new ULine(this.x2 - this.x1, this.y2 - this.y1);
        ug = ug.apply(new UStroke(3.0, 3.0, 1.0));
        ug.apply(new UTranslate(this.x1, this.y1)).draw(line);
        TextBlock label = this.display.create(FontConfiguration.create(skinParam, FontParam.ARROW, null), HorizontalAlignment.CENTER, skinParam);
        Dimension2D dimLabel = label.calculateDimension(ug.getStringBounder());
        double x = (this.x1 + this.x2) / 2.0 - dimLabel.getWidth() / 2.0;
        double y = (this.y1 + this.y2) / 2.0 - dimLabel.getHeight() / 2.0;
        label.drawU(ug.apply(new UTranslate(x, y)));
    }
}

