/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryService;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.SecurityService;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.exceptions.utils.ExtractorUtil;
import nl.avisi.confluence.plugins.gitplugin.git.providers.RepositoryUrlProvider;
import nl.avisi.confluence.plugins.gitplugin.license.LicenseChecker;
import nl.avisi.confluence.plugins.gitplugin.license.exception.InvalidLicenseException;
import nl.avisi.confluence.plugins.gitplugin.macro.MacroFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ListGitFolderMacro
implements Macro {
    private static final Logger LOG = LoggerFactory.getLogger(ListGitFolderMacro.class);
    private final RepositoryService repositoryService;
    private final I18nResolver i18nResolver;
    private final SecurityService securityService;
    private final LicenseChecker licenseChecker;
    private final PageBuilderService pageBuilderService;
    private final SettingsManager settingsManager;
    private final MacroFunctions macroFunctions;

    @Autowired
    ListGitFolderMacro(@Nonnull RepositoryService repositoryService, @Nonnull I18nResolver i18nResolver, @Nonnull SecurityService securityService, @Nonnull LicenseChecker licenseChecker, @Nonnull PageBuilderService pageBuilderService, @Nonnull SettingsManager settingsManager) {
        this.repositoryService = (RepositoryService)Preconditions.checkNotNull((Object)repositoryService);
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
        this.securityService = (SecurityService)Preconditions.checkNotNull((Object)securityService);
        this.licenseChecker = (LicenseChecker)Preconditions.checkNotNull((Object)licenseChecker);
        this.pageBuilderService = pageBuilderService;
        this.settingsManager = settingsManager;
        this.macroFunctions = new MacroFunctions(new RepositoryUrlProvider());
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        try {
            this.licenseChecker.validateLicense();
        }
        catch (InvalidLicenseException e) {
            return this.createHtmlErrorMessage(this.i18nResolver.getText(e.getMessage()));
        }
        String macroRepositoryId = parameters.get("repository-id");
        Optional<Repository> optional = this.repositoryForMacroRepositoryId(macroRepositoryId);
        this.fillNonDeclaredVariables(parameters, Arrays.asList("commit-id", "folder", "branch"));
        String commit = this.filterOutEmptyString(parameters.get("commit-id"));
        String path = this.filterOutEmptyString(parameters.get("folder"));
        String branch = this.filterOutEmptyString(parameters.get("branch"));
        String string = path = path == null ? "/" : path;
        if (!optional.isPresent()) {
            return this.createHtmlMessage(this.i18nResolver.getText("gitplugin.macro.notfound"), this.i18nResolver.getText("gitplugin.macro.viewfile.repositorynotfound", new Serializable[]{macroRepositoryId}));
        }
        Repository repository = optional.get();
        if (!this.securityService.canUse(repository)) {
            return this.createHtmlErrorMessage(this.i18nResolver.getText("gitplugin.macro.viewfile.notallowed"));
        }
        try {
            String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl() + "/rest/git-plugin/1.0/repositories/";
            String isExporting = this.macroFunctions.checkForExportingEntity(context);
            if (isExporting.equals("word") || isExporting.equals("pdf")) {
                HashMap<String, Object> information = new HashMap<String, Object>();
                if (path.equals("/")) {
                    information.put("title", repository.getName());
                } else {
                    information.put("titel", repository.getName() + "/" + path);
                }
                information.put("repository", repository);
                information.put("sourceUri", this.macroFunctions.resolveSourceUri(repository, branch, path, "folder"));
                information.put("content", this.repositoryService.getRepositoryDirectory(repository, branch, commit, path));
                if (isExporting.equals("word")) {
                    return VelocityUtils.getRenderedTemplate((String)"/views/macro/exportFolderMacroWord.vm", information);
                }
                return VelocityUtils.getRenderedTemplate((String)"/views/macro/exportFolderMacroPDF.vm", information);
            }
            this.pageBuilderService.assembler().resources().requireContext("nl.avisi.confluence.plugins.gitplugin.list-folder");
            return "<div class=container data-repo=" + macroRepositoryId + " data-branch=" + branch + " data-commit=" + commit + " data-baseurl=" + baseUrl + " data-path=" + path + "> </div>";
        }
        catch (UndeclaredThrowableException u) {
            Message errorMessage = ExtractorUtil.getI18nMessageFromException(u);
            return this.createHtmlMessage(this.i18nResolver.getText("gitplugin.macro.notreadable"), this.i18nResolver.getText(errorMessage.getKey(), errorMessage.getArguments()));
        }
        catch (Throwable t) {
            LOG.warn("The Git Add-on threw an unexpected exception...", t);
            return this.createHtmlErrorMessage(this.i18nResolver.getText("gitplugin.macro.unexpectederror"));
        }
    }

    private Map fillNonDeclaredVariables(Map<String, String> parameters, List<String> variables) {
        for (String variable : variables) {
            if (parameters.containsKey(variable)) continue;
            parameters.put(variable, "");
        }
        return parameters;
    }

    private String filterOutEmptyString(String variable) {
        if (variable.equals("")) {
            return null;
        }
        return variable;
    }

    private Optional<Repository> repositoryForMacroRepositoryId(String macroRepositoryId) {
        if (macroRepositoryId.matches("^\\d+$")) {
            int repositoryId = Integer.parseInt(macroRepositoryId);
            return this.repositoryService.get(repositoryId);
        }
        if (macroRepositoryId.split("/").length == 2) {
            String[] components = macroRepositoryId.split("/");
            String serverName = components[0];
            String repositoryName = components[1];
            return this.repositoryService.findByName(repositoryName).stream().filter(repository -> repository.getServer().getName().equals(serverName)).findFirst();
        }
        return Optional.empty();
    }

    private String createHtmlErrorMessage(String body) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("body", body);
        return VelocityUtils.getRenderedTemplate((String)"/views/macro/error.vm", context);
    }

    private String createHtmlMessage(String title, String body) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("title", title);
        context.put("body", body);
        return VelocityUtils.getRenderedTemplate((String)"/views/macro/message.vm", context);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

