/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.git.jobs;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.TermQuery;
import com.atlassian.confluence.search.v2.sort.ModifiedSort;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import nl.avisi.confluence.plugins.gitplugin.configuration.dao.RepositoryDao;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryHealthCheckService;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryService;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.extractor.ViewGitFileExtractor;
import nl.avisi.confluence.plugins.gitplugin.git.exception.RepositoryUpdateException;
import nl.avisi.confluence.plugins.gitplugin.git.manager.VCSRepositoryManager;
import nl.avisi.confluence.plugins.gitplugin.license.LicenseChecker;
import nl.avisi.confluence.plugins.gitplugin.license.exception.InvalidLicenseException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullJob
implements JobRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(PullJob.class);
    private static final int BATCH_SIZE = 1000;
    private final RepositoryService repositoryService;
    private final LicenseChecker licenseChecker;
    private final I18nResolver i18nResolver;
    private final TransactionTemplate transactionTemplate;
    private final AccessModeCompatService accessModeService;
    private final VCSRepositoryManager repositoryManager;
    private final SearchManager searchManager;
    private final PageService pageService;
    private final ConfluenceIndexer confluenceIndexer;
    private final RepositoryDao repositoryDao;
    private final RepositoryHealthCheckService repositoryHealthCheckService;

    public PullJob(RepositoryService repositoryService, LicenseChecker licenseChecker, I18nResolver i18nResolver, TransactionTemplate transactionTemplate, AccessModeCompatService accessModeService, VCSRepositoryManager repositoryManager, SearchManager searchManager, PageService pageService, ConfluenceIndexer confluenceIndexer, RepositoryDao repositoryDao, RepositoryHealthCheckService repositoryHealthCheckService) {
        this.repositoryService = repositoryService;
        this.licenseChecker = licenseChecker;
        this.i18nResolver = i18nResolver;
        this.transactionTemplate = transactionTemplate;
        this.accessModeService = accessModeService;
        this.repositoryManager = repositoryManager;
        this.searchManager = searchManager;
        this.pageService = pageService;
        this.confluenceIndexer = confluenceIndexer;
        this.repositoryDao = repositoryDao;
        this.repositoryHealthCheckService = repositoryHealthCheckService;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        LOGGER.debug("Starting git pull job");
        try {
            this.licenseChecker.validateLicense();
        }
        catch (InvalidLicenseException e) {
            LOGGER.warn(this.i18nResolver.getText(e.getMessage()));
            return JobRunnerResponse.failed((Throwable)e);
        }
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            LOGGER.warn("Read-only mode enabled, not syncing repositories");
            return JobRunnerResponse.success();
        }
        LOGGER.debug("Checking read/write permissions");
        try {
            this.repositoryHealthCheckService.performWriteTest();
        }
        catch (Exception e) {
            LOGGER.error("There was a problem writing to the plugin root directory", (Throwable)e);
        }
        LOGGER.debug("Done checking read/write permissions");
        LOGGER.debug("Fetching repository list");
        Collection<Repository> repositories = this.getRepositories();
        LOGGER.debug("Fetched {} repositories", (Object)repositories.size());
        int failed = 0;
        for (Repository repository : repositories) {
            if (jobRunnerRequest.isCancellationRequested()) continue;
            LOGGER.debug("Updating repository: {}", (Object)repository.getName());
            try {
                this.updateRepositoryWithTransaction(repository);
                this.updateViewMacroIndexes(repository);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to update repository: {}", (Object)repository.getName());
                LOGGER.warn("Failed to update repository because: ", (Throwable)e);
                ++failed;
            }
            LOGGER.debug("Updated repository: {}", (Object)repository.getName());
        }
        LOGGER.info("Finished updating repositories {}/{} updates were successfull", (Object)(repositories.size() - failed), (Object)repositories.size());
        return JobRunnerResponse.success();
    }

    private void updateRepositoryWithTransaction(Repository repository) {
        this.transactionTemplate.execute(() -> {
            try {
                if (!repository.isArchived()) {
                    this.repositoryService.updateRepository(repository);
                }
            }
            catch (RepositoryUpdateException e) {
                LOGGER.warn("The update of repository with the name \"{}\" has failed, with error message: {}", (Object)repository.getName(), (Object)e.getMessage());
                LOGGER.debug("Update of a repository has failed", (Throwable)e);
            }
            return null;
        });
    }

    private void updateViewMacroIndexes(Repository repository) throws IOException, GitAPIException, InvalidSearchException {
        LOGGER.debug("Start updateViewMacroIndexes for repository={} ", (Object)repository.getID());
        Long lastCommitTimestamp = this.repositoryManager.getLastCommitTimeStamp(repository);
        Long lastIndexedTimestamp = Optional.ofNullable((Long)this.transactionTemplate.execute(repository::getLastIndexedTimestamp)).orElse(0L);
        LOGGER.debug("Last commit timestamp={} that has been synced for repository={} ", (Object)lastIndexedTimestamp, (Object)repository.getID());
        Set<String> updatedPaths = this.repositoryManager.getChangedFilePaths(repository, lastIndexedTimestamp);
        LOGGER.debug("Found {} paths that were modified for repository={}", (Object)updatedPaths.size(), (Object)repository.getID());
        LOGGER.debug("Found the following paths {} for repository={}", updatedPaths, (Object)repository.getID());
        if (updatedPaths.size() == 0) {
            LOGGER.debug("No changes detected for repository={}", (Object)repository.getID());
            LOGGER.debug("Done with updateViewMacroIndexes for repository={} ", (Object)repository.getID());
            return;
        }
        List searchFilters = updatedPaths.stream().map(path -> new TermQuery("gfc-repository-and-path", ViewGitFileExtractor.createRepositoryPlusPathValue(repository, path))).collect(Collectors.toList());
        SearchQuery filter = (SearchQuery)BooleanQuery.builder().addShould(searchFilters).build();
        ContentSearch query = new ContentSearch(filter, (SearchSort)ModifiedSort.DEFAULT, 0, 1000);
        boolean isDrained = false;
        while (!isDrained) {
            SearchResults search = this.searchManager.search((ISearch)query);
            isDrained = search.isLastPage();
            List results = search.getAll();
            LOGGER.debug("Found a batch of {} pages that have references to the changed files repository={}", (Object)results.size(), (Object)repository.getID());
            AtomicInteger updatedPages = new AtomicInteger();
            results.forEach(searchResult -> {
                Page page = this.pageService.getTitleAndSpaceKeyPageLocator(searchResult.getSpaceKey(), searchResult.getDisplayTitle()).getPage();
                if (page != null) {
                    this.confluenceIndexer.index((Searchable)page);
                    updatedPages.getAndIncrement();
                }
            });
            LOGGER.debug("updated a batch of {} pages that have references to the changed files repository={}", (Object)updatedPages.get(), (Object)repository.getID());
            if (isDrained) continue;
            LOGGER.debug("Found another batch of pages to update for repository={}", (Object)repository.getID());
            query = search.getNextPageSearch();
        }
        this.transactionTemplate.execute(() -> {
            LOGGER.debug("Update last indexed timestamp to {} repository={}", (Object)lastCommitTimestamp, (Object)repository.getID());
            repository.setLastIndexedTimestamp(lastCommitTimestamp);
            this.repositoryDao.update(repository);
            return repository;
        });
        LOGGER.debug("Done with updateViewMacroIndexes for repository={} ", (Object)repository.getID());
    }

    private Collection<Repository> getRepositories() {
        return (Collection)this.transactionTemplate.execute(() -> this.repositoryService.getRepositories(false));
    }
}

