/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.flexmark.extentions;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.google.common.collect.Sets;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeBlockResolver
implements NodeRenderer,
NodeRendererFactory {
    private Map<String, String> parameters;
    private ConversionContext conversionContext;
    private final XhtmlContent xhtmlContent;
    private static final Logger LOG = LoggerFactory.getLogger(CodeBlockResolver.class);
    private static Set<String> SUPPORTED_LANGUAGES = Sets.newHashSet((Object[])new String[]{"actionscript3", "applescript", "bash", "c#", "cpp", "css", "coldfusion", "cucumber-nl", "delphi", "diff", "erl", "groovy", "xml", "java", "jfx", "js", "php", "perl", "text", "powershell", "py", "ruby", "sql", "sass", "scala", "vb", "yml"});

    CodeBlockResolver(Map<String, String> parameters, ConversionContext conversionContext, XhtmlContent xhtmlContent) {
        this.parameters = parameters;
        this.conversionContext = conversionContext;
        this.xhtmlContent = xhtmlContent;
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<FencedCodeBlock>(FencedCodeBlock.class, (node, context, html) -> {
            String languageFromMarkdown = String.valueOf(node.getInfo());
            String language = this.mapToSupportedLanguageInCodeBlockMacro(languageFromMarkdown);
            try {
                html.rawIndentedPre(this.renderCodeMacro(node.getContentChars().normalizeEOL(), language, this.conversionContext));
            }
            catch (XhtmlException | XMLStreamException e) {
                LOG.warn("Failed to render codeblock", e);
            }
        }));
        return set;
    }

    private String mapToSupportedLanguageInCodeBlockMacro(String languageFromMarkdown) {
        if (SUPPORTED_LANGUAGES.contains(languageFromMarkdown.toLowerCase())) {
            return languageFromMarkdown.toLowerCase();
        }
        return null;
    }

    public String renderCodeMacro(String code, String language, ConversionContext context) throws XhtmlException, XMLStreamException {
        Object xhtml = "<ac:structured-macro ac:name=\"code\">";
        if (language != null) {
            xhtml = (String)xhtml + "<ac:parameter ac:name=\"language\">" + language + "</ac:parameter>";
        }
        xhtml = (String)xhtml + "<ac:plain-text-body><![CDATA[" + code + "]]></ac:plain-text-body></ac:structured-macro>\n";
        return this.xhtmlContent.convertStorageToView((String)xhtml, context);
    }

    @Override
    @NotNull
    public NodeRenderer apply(@NotNull DataHolder dataHolder) {
        return this;
    }
}

