/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.extractor;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.plugins.index.api.StringFieldDescriptor;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.git.FileDetails;
import nl.avisi.confluence.plugins.gitplugin.git.manager.GitRepositoryManager;
import nl.avisi.confluence.plugins.gitplugin.macro.ViewGitFileMacro;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewGitFileExtractor
implements Extractor2 {
    private static final Logger LOG = LoggerFactory.getLogger(ViewGitFileExtractor.class);
    public static final String GFC_REPOSITORY_AND_PATH = "gfc-repository-and-path";
    private final GitRepositoryManager repositoryManager;
    private final XhtmlContent xhtmlContent;

    ViewGitFileExtractor(@Nonnull GitRepositoryManager repositoryManager, @Nonnull XhtmlContent xhtmlContent) {
        this.repositoryManager = repositoryManager;
        this.xhtmlContent = xhtmlContent;
    }

    private boolean shouldIndex(MacroDefinition macroDefinition) {
        return FilenameUtils.getExtension((String)macroDefinition.getParameter("path")).equals("md");
    }

    public static String createRepositoryPlusPathValue(Repository repository, String path) {
        return repository.getID() + ":" + path;
    }

    public StringBuilder extractText(Object searchable) {
        StringBuilder builder = new StringBuilder();
        if (searchable instanceof Page) {
            Page page = (Page)searchable;
            try {
                this.xhtmlContent.handleMacroDefinitions(page.getBodyAsString(), null, macroDefinition -> {
                    if (macroDefinition.getName().equals("view-git-file") && this.shouldIndex(macroDefinition)) {
                        String branch = macroDefinition.getParameter("branch");
                        String commitId = macroDefinition.getParameter("commit-id");
                        String path = macroDefinition.getParameter("path");
                        LOG.debug("Found view-git-file macro on page={} branch={} commitId={} path={}", new Object[]{page, branch, commitId, path});
                        Optional<Repository> optionalRepository = ViewGitFileMacro.repositoryForMacroRepositoryId(macroDefinition.getParameter("repository-id"));
                        optionalRepository.ifPresent(repository -> {
                            Map parameters = macroDefinition.getParameters();
                            try {
                                FileDetails fileDetails = this.repositoryManager.getFileDetails((Repository)repository, branch, commitId, path);
                                LOG.debug("Retrieving text for indexing for file {} on page {}", (Object)fileDetails, (Object)page);
                                builder.append(ViewGitFileMacro.getStringSelection(parameters, fileDetails.getFileContents()));
                            }
                            catch (IOException e) {
                                LOG.error("Retrieving text for indexing the view-git-file macro output failed macroDefinition={}", (Object)macroDefinition, (Object)e);
                            }
                        });
                    }
                });
            }
            catch (XhtmlException e) {
                LOG.error("Retrieving the text for indexing the view-git-file macro output failed: ", (Throwable)e);
            }
        }
        return builder;
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (searchable instanceof Page) {
            Page page = (Page)searchable;
            try {
                this.xhtmlContent.handleMacroDefinitions(page.getBodyAsString(), null, macroDefinition -> {
                    if (macroDefinition.getName().equals("view-git-file") && this.shouldIndex(macroDefinition)) {
                        String branch = macroDefinition.getParameter("branch");
                        String commitId = macroDefinition.getParameter("commit-id");
                        String path = macroDefinition.getParameter("path");
                        LOG.debug("Found view-git-file macro on page={} branch={} commitId={} path={}", new Object[]{page, branch, commitId, path});
                        Optional<Repository> optionalRepository = ViewGitFileMacro.repositoryForMacroRepositoryId(macroDefinition.getParameter("repository-id"));
                        optionalRepository.ifPresent(repository -> {
                            Map parameters = macroDefinition.getParameters();
                            try {
                                FileDetails fileDetails = this.repositoryManager.getFileDetails((Repository)repository, branch, commitId, path);
                                LOG.debug("Extracting fields for indexing file {} on page {}", (Object)fileDetails, (Object)page);
                                builder.add((Object)new StringFieldDescriptor(GFC_REPOSITORY_AND_PATH, ViewGitFileExtractor.createRepositoryPlusPathValue(repository, macroDefinition.getParameter("path")), FieldDescriptor.Store.NO));
                            }
                            catch (IOException e) {
                                LOG.error("Extracting fields for indexing the view-git-file macro output failed macroDefinition={}", (Object)macroDefinition, (Object)e);
                            }
                        });
                    }
                });
            }
            catch (XhtmlException e) {
                LOG.error("Extracting fields for indexing the view-git-file macro output failed: ", (Throwable)e);
            }
        }
        return builder.build();
    }
}

