/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.service;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import nl.avisi.confluence.plugins.gitplugin.configuration.rest.RestRepositoryHealthCheckFailed;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryHealthCheckService;
import nl.avisi.confluence.plugins.gitplugin.configuration.service.RepositoryService;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import nl.avisi.confluence.plugins.gitplugin.exceptions.GitAddonException;
import nl.avisi.confluence.plugins.gitplugin.git.exception.RepositoryInitializationException;
import nl.avisi.confluence.plugins.gitplugin.git.manager.GitRepositoryManager;
import nl.avisi.confluence.plugins.gitplugin.git.providers.LocalDirectoryProvider;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryHealthCheckServiceImpl
implements RepositoryHealthCheckService {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryHealthCheckServiceImpl.class);
    private LocalDirectoryProvider localDirectoryProvider;
    private GitRepositoryManager gitRepositoryManager;
    private RepositoryService repositoryService;

    public RepositoryHealthCheckServiceImpl(@Nonnull GitRepositoryManager gitRepositoryManager, @Nonnull LocalDirectoryProvider localDirectoryProvider, @Nonnull RepositoryService repositoryService) {
        this.localDirectoryProvider = localDirectoryProvider;
        this.gitRepositoryManager = gitRepositoryManager;
        this.repositoryService = repositoryService;
    }

    @Override
    public List<RestRepositoryHealthCheckFailed> check() {
        return this.repositoryService.getRepositories(false).stream().filter(repository -> !repository.isArchived()).filter(repository -> !this.localDirectoryProvider.getLocalDirectory((Repository)repository).exists()).map(repository -> new RestRepositoryHealthCheckFailed(repository.getName(), RestRepositoryHealthCheckFailed.Problem.MISSING)).collect(Collectors.toList());
    }

    @Override
    public List<RestRepositoryHealthCheckFailed> fix() {
        return this.repositoryService.getRepositories(false).stream().filter(repository -> !this.localDirectoryProvider.getLocalDirectory((Repository)repository).exists()).filter(repository -> {
            try {
                this.gitRepositoryManager.create((Repository)repository);
            }
            catch (RepositoryInitializationException e) {
                LOG.error("Failed to restore repository", (Throwable)e);
                return true;
            }
            return false;
        }).map(repository -> new RestRepositoryHealthCheckFailed(repository.getName(), RestRepositoryHealthCheckFailed.Problem.FAILED_TO_FIX)).collect(Collectors.toList());
    }

    @Override
    public void performWriteTest() throws GitAddonException {
        File rootDirectory = this.localDirectoryProvider.getPluginRootDirectory();
        if (!rootDirectory.canWrite()) {
            throw new GitAddonException("Plugin root folder is not writable");
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(rootDirectory, "_test.write")));){
            writer.write("write test " + DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss").format(LocalDateTime.now()));
        }
        catch (IOException e) {
            throw new GitAddonException("Simple write to plugin root failed", e);
        }
        try {
            File fileToLock = new File(rootDirectory, "_test.write");
            LockFile lockFile = new LockFile(fileToLock);
            lockFile.lock();
            lockFile.unlock();
        }
        catch (Exception e) {
            throw new GitAddonException("Writing a lock file failed", e);
        }
    }
}

