/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.rest;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import java.util.Collection;
import javax.annotation.Nullable;
import nl.avisi.confluence.plugins.gitplugin.core.Server;
import nl.avisi.confluence.plugins.gitplugin.core.ServerAuthentication;
import nl.avisi.confluence.plugins.gitplugin.core.ServerInfo;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class RestServer {
    public static final String PASSWORD_MASK = "#####";
    @JsonProperty
    private Integer id;
    @JsonProperty
    private String name;
    @JsonProperty
    private ServerInfo serverInfo;
    @JsonProperty
    private ServerAuthentication serverAuthentication;

    public RestServer(Server server) {
        Preconditions.checkNotNull((Object)server);
        this.id = server.getID();
        this.name = server.getName();
        this.serverInfo = new ServerInfo(server.getConnectionProtocol(), server.getHost(), server.getPort());
        this.serverAuthentication = new ServerAuthentication(server.getAuthenticationMethod(), server.getSshKey(), server.getUsername(), this.getMaskedPassword(server.getPassword()));
    }

    @JsonCreator
    public RestServer(@JsonProperty(value="id") int id, @JsonProperty(value="name") String name, @JsonProperty(value="serverInfo") ServerInfo serverInfo, @JsonProperty(value="serverAuthentication") ServerAuthentication serverAuthentication) {
        this.id = id;
        this.name = name;
        this.serverInfo = serverInfo;
        this.serverAuthentication = serverAuthentication;
    }

    public static Collection<RestServer> collection(Collection<? extends Server> repositories) {
        return Collections2.transform(repositories, (Function)new Transformer());
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public ServerAuthentication getServerAuthentication() {
        return this.serverAuthentication;
    }

    private String getMaskedPassword(String password) {
        if (!Strings.isNullOrEmpty((String)password)) {
            return PASSWORD_MASK;
        }
        return password;
    }

    public static class Transformer
    implements Function<Server, RestServer> {
        @Nullable
        public RestServer apply(@Nullable Server server) {
            return new RestServer(server);
        }
    }
}

