/*
 * Decompiled with CFR 0.152.
 */
package nl.avisi.confluence.plugins.gitplugin.configuration.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import nl.avisi.confluence.plugins.gitplugin.configuration.dao.GroupDao;
import nl.avisi.confluence.plugins.gitplugin.core.Group;
import nl.avisi.confluence.plugins.gitplugin.core.Repository;
import org.apache.commons.lang.ArrayUtils;

public class ActiveObjectsGroupDao
implements GroupDao {
    private final ActiveObjects activeObjects;

    public ActiveObjectsGroupDao(@Nonnull ActiveObjects activeObjects) {
        this.activeObjects = (ActiveObjects)Preconditions.checkNotNull((Object)activeObjects);
    }

    @Override
    public void save(String groupName, Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        if (this.groupExists(groupName, repository)) {
            return;
        }
        Group group = (Group)this.activeObjects.create(Group.class, new DBParam[]{new DBParam("NAME", (Object)groupName), new DBParam("REPOSITORY_ID", (Object)repository)});
        group.save();
    }

    private boolean groupExists(String groupName, Repository repository) {
        Object[] result = (Group[])this.activeObjects.find(Group.class, Query.select().where("NAME = ? AND REPOSITORY_ID = ?", new Object[]{groupName, repository}));
        return !ArrayUtils.isEmpty((Object[])result);
    }

    @Override
    public void delete(Group ... group) {
        this.activeObjects.delete((RawEntity[])group);
    }
}

