/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.Objects;
import net.sourceforge.plantuml.api.ThemeStyle;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.style.AutomaticCounter;
import net.sourceforge.plantuml.style.DarkString;
import net.sourceforge.plantuml.style.Value;
import net.sourceforge.plantuml.style.ValueColor;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.HColorSimple;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class ValueImpl
implements Value {
    private final DarkString value;

    public static ValueImpl dark(String value, AutomaticCounter counter) {
        return new ValueImpl(new DarkString(null, Objects.requireNonNull(value), counter.getNextInt()));
    }

    public static ValueImpl regular(String value, AutomaticCounter counter) {
        return new ValueImpl(new DarkString(Objects.requireNonNull(value), null, counter.getNextInt()));
    }

    public static ValueImpl regular(String value, int priority) {
        return new ValueImpl(new DarkString(Objects.requireNonNull(value), null, priority));
    }

    public Value mergeWith(Value other) {
        if (other == null) {
            return this;
        }
        if (other instanceof ValueImpl) {
            return new ValueImpl(this.value.mergeWith(((ValueImpl)other).value));
        }
        if (other instanceof ValueColor) {
            if (other.getPriority() > this.getPriority()) {
                return other;
            }
            return this;
        }
        throw new UnsupportedOperationException();
    }

    private ValueImpl(DarkString value) {
        this.value = value;
    }

    public Value addPriority(int delta) {
        return new ValueImpl(this.value.addPriority(delta));
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public String asString() {
        return this.value.getValue1();
    }

    @Override
    public HColor asColor(ThemeStyle themeStyle, HColorSet set) {
        String value1 = this.value.getValue1();
        if ("none".equalsIgnoreCase(value1)) {
            return null;
        }
        if ("transparent".equalsIgnoreCase(value1)) {
            return HColorUtils.transparent();
        }
        if (value1 == null) {
            throw new IllegalArgumentException(this.value.toString());
        }
        HColor result = set.getColorOrWhite(themeStyle, value1);
        if (this.value.getValue2() != null) {
            HColor dark = set.getColorOrWhite(themeStyle, this.value.getValue2());
            return ((HColorSimple)result).withDark(dark);
        }
        return result;
    }

    @Override
    public boolean asBoolean() {
        return "true".equalsIgnoreCase(this.value.getValue1());
    }

    @Override
    public int asInt() {
        return Integer.parseInt(this.value.getValue1());
    }

    @Override
    public double asDouble() {
        return Double.parseDouble(this.value.getValue1());
    }

    @Override
    public int asFontStyle() {
        if (this.value.getValue1().equalsIgnoreCase("bold")) {
            return 1;
        }
        if (this.value.getValue1().equalsIgnoreCase("italic")) {
            return 2;
        }
        return 0;
    }

    @Override
    public HorizontalAlignment asHorizontalAlignment() {
        return HorizontalAlignment.fromString(this.asString());
    }

    @Override
    public int getPriority() {
        return this.value.getPriority();
    }
}

