var vSH = vSH || {};
vSH.doAppendAsterisks = function () {
    //console.log("now appending asterisks");
    var currentQueryString = AJS.$("#search-filter-input").val();
    currentQueryString = currentQueryString.replace("*", "").split(" ");
    AJS.$("#search-filter-input").val(jQuery.map(currentQueryString, function (val, i) {
        return val + "*";
    }).join(" "));
}

vSH.doHideMessage = function () {

    //console.log("now removing message");
    AJS.$("#vSH_expandSearchMessage").closest(".aui-message").remove();

}
$(function () {
    var title1 = $(document).prop('title');

    document.title = document.title.replace(/.vhighlight title= 'This has been highlighted as your previous search term'>Test<.vhighlight>../, "");
    document.title = document.title.replace(/- <vhighlight title= 'This has been highlighted as your previous search term'><.vhighlight>Demonstration<vhighlight title= 'This has been highlighted as your previous search term'><.vhighlight> <vhighlight title= 'This has been highlighted as your previous search term'><.vhighlight>Space<vhighlight title= 'This has been highlighted as your previous search term'...vhighlight./, "");
});

AJS.$(document).ready(function () {

    var mainContentOffsetTop;
    function stickyToolbarOnScrollHandlerForLinchpin(e) {
        var $el = AJS.$("#main-header");
        var offset = AJS.$("#header")[0].getBoundingClientRect().bottom;
        var isLinchpinHeaderVisible = mainContentOffsetTop - offset < 0;
        var mainContentOffsetLeft = AJS.$("#main")[0].getBoundingClientRect().left;
        var isFixedLinchpinHeader = AJS.$("#linchpin-header #header.fixed-header").length > 0;
        if(offset < 0) offset = 0;
        if (!isLinchpinHeaderVisible || isFixedLinchpinHeader){
            AJS.$("#main-header").addClass("vsh-sticking");
            $el.css({"position": "fixed", "top": offset + "px", "margin-top": "0px"});
            $el.css({"left": mainContentOffsetLeft + 45 + "px"});
        }
        if (isLinchpinHeaderVisible){
            AJS.$("#main-header").removeClass("vsh-sticking");
            $el.css({"position": "static", "top": "0px", "margin-top": ""});
        }
    }


    var allSelectedItemsCount;

    AJS.$(document).on("click", "#vsh", function (e) {
        e.preventDefault();
        mainContentOffsetTop = AJS.$("#main").offset().top;

        var $vshMainSearchButton = AJS.$(this);

        AJS.$($vshMainSearchButton).toggleClass("active");

        var isMainSearchButtonActive = AJS.$($vshMainSearchButton).is(".active");

        var mainContent = document.getElementById("main-content");
        var url = new URL(document.URL);
        var searchParam = url.searchParams.get("search");
        findAndReplaceDOMText(mainContent, {
            preset: 'prose',
            find: new RegExp(searchParam, "gi"),
            wrap: 'vhighlight'
        });

        // This way we can exclude stuff from getting surrounded with <vhighlight></vhighlight>
        AJS.$('vhighlight').within('.code.panel').contents().unwrap();
        AJS.$('vhighlight').within('vhighlight vhighlight').contents().unwrap();

        if(isMainSearchButtonActive){
            var isLinchpinHeader = AJS.$("#linchpin-header").length > 0;

            AJS.$("#main-header").addClass("vsh-sticky");
            if(isLinchpinHeader){
                AJS.$("#main-header").addClass("vsh-sticky vsh-left");
                AJS.$(window).on("scroll", stickyToolbarOnScrollHandlerForLinchpin);
            } else {
                AJS.$("head").append("<style id='vsh-toolbar-dynamic-style'>#main-header.vsh-sticky{ top:" + mainContentOffsetTop + "px !important }</style>")
            }

        } else {
            AJS.$("#main-header").removeClass("vsh-sticky vsh-left vsh-sticking");
            AJS.$("#vsh-sticky-style").remove();
        }

        allSelectedItemsCount = AJS.$("vhighlight").length;
        if (allSelectedItemsCount == null) {
            allSelectedItemsCount = 0;
        }
        AJS.$("#vsh-previous").toggleClass("off");
        AJS.$("#vsh-next").toggleClass("off");
        AJS.$("#vHighlighterCounter").toggleClass("off");
        updateCounterWithSelectedHighlightItemNumber();
        if (allSelectedItemsCount > 0) {
            if(!AJS.$("#vHighlighterCounter").is(".off")){
                highlightElementInDirection(true);
            }
        }
    });

    function scrollToSelectedHighlightElement() {
        AJS.$([document.documentElement, document.body]).animate({
            scrollTop: AJS.$(getSelectedHighlightElement()).offset().top - 350
        }, 200);
    }

    function getSelectedHighlightElement() {
        return AJS.$("vhighlight.selected");
    }

    function getFirstHighlightElement(){
        return AJS.$("vhighlight").eq(0);
    }

    function getLastHighlightElement(){
        return AJS.$("vhighlight").last();
    }

    function getSelectedHighlightElementIndex(){
        return AJS.$("vhighlight").index(getSelectedHighlightElement());
    }

    function getHighlightElementIndex(highlightElement){
        return AJS.$("vhighlight").index(highlightElement);
    }

    function getHighlightElementCount(){
        return AJS.$("vhighlight").length;
    }

    function updateCounterWithSelectedHighlightItemNumber(){
        AJS.$("#vHighlighterCounter").html((getSelectedHighlightElementIndex() + 1) + " / " + AJS.$("vhighlight").length);
    }


    function getNextHighlightElement(isForward){
        if(AJS.$("vhighlight.selected").is(AJS.$("vhighlight").last()) && !!isForward) return AJS.$("vhighlight").first();
        if(AJS.$("vhighlight.selected").is(AJS.$("vhighlight").first()) && !isForward) return AJS.$("vhighlight").last();
        var currentElementIndex = getHighlightElementIndex(AJS.$("vhighlight.selected"));
        if(!!isForward) currentElementIndex++;
        if(!isForward) currentElementIndex--;
        return AJS.$("vhighlight").eq(currentElementIndex);
    }

    function highlightElementInDirection(isForward){
        var $currentlySelectedItem = getSelectedHighlightElement();
        var $nextHighlightElement;
        if($currentlySelectedItem.length < 1){
            $nextHighlightElement = isForward ? getFirstHighlightElement() : getLastHighlightElement();
        }
        if($currentlySelectedItem.length > 0){
            $nextHighlightElement = getNextHighlightElement(isForward);
        }

        AJS.$($currentlySelectedItem).removeClass("selected");
        AJS.$($nextHighlightElement).addClass("selected");
        updateCounterWithSelectedHighlightItemNumber();
        if($currentlySelectedItem.length < 1 || $nextHighlightElement.length < 1) return;
        if(getTopDifferenceOfTwoElements($currentlySelectedItem, $nextHighlightElement) > 3) {

            scrollToSelectedHighlightElement();
        }
    }

    function getTopDifferenceOfTwoElements(firstElement, secondElement) {
        return Math.abs(AJS.$(firstElement).offset().top - AJS.$(secondElement).offset().top);
    }

    AJS.$(document).on("click", "#vsh-next, #vsh-previous", function (e) {
        e.preventDefault();
        var shouldGoForwards = AJS.$(this).is("#vsh-next");
        highlightElementInDirection(shouldGoForwards);
    });

    AJS.$(document).on("click", "#vHighlighterCounter", function (e) {
        e.preventDefault();
    });

    AJS.$.ajax({
        url: AJS.contextPath() + "/rest/vsh/1.0/config/fetch",
        type: 'GET',
        contentType: "application/json",
        dataType: 'json',
        success: function (data) {
            if (data.licensed !== "yes") return;
            if (!document.URL.includes("search=")) return;

            var url = new URL(document.URL);
            var searchParam = url.searchParams.get("search");

            var mainContent = document.getElementById("main-content");
            searchParam.split(",").forEach(function(keyword){
                findAndReplaceDOMText(mainContent, {
                    preset: 'prose',
                    find: new RegExp(keyword, "gi"),
                    wrap: 'vhighlight'
                });
            });

            // This way we can exclude stuff from getting surrounded with <vhighlight></vhighlight>
            AJS.$('vhighlight').within('.code.panel').contents().unwrap();


            if (AJS.$("#main-content").find("vhighlight").length > 0) {
                AJS.$("#vsh").removeClass("off");
            }

        }
    });

    /* afaik redundant
    $("div.aui-header-secondary").bind("DOMSubtreeModified", function () {
        AJS.$("#quick-search ol li a").each(function (index, element) {

            var query = jQuery("#quick-search-query").val();
            //console.log(query + " 2")

            if (query.includes("*") || query.includes("?")) {
                query = query.replace("*", "");
                query = query.replace("?", "");

            }


            var currentUrl = $(element).attr("href");
            //console.log(currentUrl)
            if (!currentUrl.includes("search=")) {
                if (currentUrl.includes("?")) {
                    currentUrl = currentUrl + "&search=" + query;
                } else {
                    currentUrl = currentUrl + "?search=" + query;
                }
                //window.location.href = url;
                AJS.$(element).attr("href", currentUrl);

                //console.log(currentUrl)
            }
        });
    });

    // add search query for advanced search

    $("div.search-results-wrapper").bind("DOMSubtreeModified", function (e, data) {
        //console.log("changed")
        AJS.$(".search-results-container li a").each(function (index, element) {
            //console.log(element)

            var query = jQuery("#query-string").val();
            //console.log(query + " 1")

            if (query.includes("*") || query.includes("?")) {
                query = query.replace("*", "");
                query = query.replace("?", "");

            }
            var currentUrl = AJS.$(element).attr("href");
            //console.log(currentUrl)
            if (!currentUrl.includes("search=")) {
                if (currentUrl.includes("?")) {
                    currentUrl = currentUrl + "&search=" + query;
                } else {
                    currentUrl = currentUrl + "?search=" + query;
                }
                //window.location.href = url;
                AJS.$(element).attr("href", currentUrl);

                //console.log(currentUrl)
            }
        });
    });*/

    function replaceSearchMacroDropdown(inElement) {
        AJS.$("li a:not(.vsh)", inElement).each(function (index, element) {
            // console.log(element)
            var query = AJS.$(inElement).closest(".search-macro").find(".search-macro-query :input").val();
            //console.log(query + " 4")

            if (query.includes("*") || query.includes("?")) {
                query = query.replace("*", "");
                query = query.replace("?", "");
            }

            var currentUrl = $(element).attr("href");
            // console.log(currentUrl)
            if (!currentUrl.includes("search=")) {
                if (currentUrl.includes("?")) {
                    currentUrl = currentUrl + "&search=" + query;
                } else {
                    currentUrl = currentUrl + "?search=" + query;
                }
                //window.location.href = url;
                AJS.$(element).attr("href", currentUrl);
                AJS.$(element).addClass("vsh");
                //console.log(currentUrl)
            }

        });
    }

    function replaceAdvancedSearchEntries (inElement) {
        AJS.$(".search-result-link:not(.vsh)", inElement).each(function (index, element) {
            var query = jQuery("#query-string").val();

            if (query.includes("*") || query.includes("?") || query.includes("ancestorIds")) {
                query = query.replace("*", "");
                query = query.replace("?", "");

                query = query.replace(/ancestorIds:/i, "").replace(/[0-9]/g, "").replace(/AND/g, "").replace(/%/g, "");
            }


            var currentUrl = AJS.$(element).attr("href");
            if (!currentUrl.includes("search=")) {
                if (currentUrl.includes("?")) {
                    currentUrl = currentUrl + "&search=" + query;
                } else {
                    currentUrl = currentUrl + "?search=" + query;
                }
                AJS.$(element).addClass("vsh");
                AJS.$(element).attr("href", currentUrl);
            }
        });
    }

    replaceAdvancedSearchEntries(AJS.$(".search-results-container"));

    var advancedSearchObserver = new MutationObserver(function (mutations, observer) {
        // look through all mutations that just occured
        mutations.forEach(function (mutation) {
            if(AJS.$(mutation.target).is(".search-results-container")) replaceAdvancedSearchEntries(mutation.target);
            if(AJS.$(mutation.target).is(".search-macro .aui-dd-parent")) replaceSearchMacroDropdown(mutation.target);
        });
    });

    if(document.getElementById("page")) {
        advancedSearchObserver.observe(document.getElementById("page"), {
            childList: true,
            subtree: true
        });
    }

    AJS.$("vhighlight").tooltip();

    jQuery.extend(jQuery.fn, {
        // Name of our method & one argument (the parent selector)
        within: function (pSelector) {
            // Returns a subset of items using jQuery.filter
            return this.filter(function () {
                // Return truthy/falsey based on presence in parent
                return $(this).closest(pSelector).length;
            });
        }
    });
});

