var vSH = vSH || {};

vSH.cookiePrefix = "vSH_usersettings_";

vSH.typeCheckboxesRendered = false;
vSH.isAutoCompleteEnabled = false;
vSH.searchPages = false;
vSH.searchSpaces = false;
vSH.searchUsers = false;
vSH.searchBlogs = false;
vSH.searchComments = false;
vSH.searchAttachments = false;
vSH.searchArchivedSpaces = false;
vSH.applySearchArchivedSpaces = true;
vSH.spaceFilters = [];
vSH.isSearchAllSpaces = false;
vSH.isFilteringSpacesInDropdown = false;

vSH.userSetSpaceFilters = [];

function triggerSearchOnInputElement(e) {
    if (!!e && e.searchHighlighterIgnore) return;
    var input = document.querySelector('#search-filter-input');
    var nativeInputValueSetter = Object.getOwnPropertyDescriptor(window.HTMLInputElement.prototype, "value").set;
    var tempInputValue = input.value;
    nativeInputValueSetter.call(input, tempInputValue + " ");
    var ev2 = new Event('change', {bubbles: true});
    input.dispatchEvent(ev2);
    nativeInputValueSetter.call(input, tempInputValue);
    input.dispatchEvent(ev2);
}

/*
var oldFetch = fetch;
fetch = function (url, options) {
    if (url.indexOf("rest/api/search") > -1) {

        var newUrl = new URL(location.origin + url);

        var cql = newUrl.searchParams.get("cql");

        if (vSH.isAutoCompleteEnabled) {
            cql = cql.replace(/siteSearch ~ "(.*?)"/, 'siteSearch ~ "$1*"');
        }

/!*        if (vSH.spaceFilters.length > 0) {
            var spaceString = '';
            vSH.spaceFilters.forEach(function (spaceFilter) {
                if (spaceFilter.searchEnabled) {
                    if (spaceString.length > 0) {
                        spaceString += ',';
                    }
                    spaceString += '"' + spaceFilter.spaceKey + '"';
                }
            });

            if (!cql.includes('AND space in')) {
                cql = cql.replace(/siteSearch ~ "(.*?)"/, 'siteSearch ~ "$1" AND space in (' + spaceString + ')');
            }
        }*!/

        var typeSearch = [];
        if (vSH.searchPages || AJS.$('#content-type-page').attr('checked') === 'checked') {
            typeSearch.push('"page"');
        }
        if (vSH.searchSpaces || AJS.$('#content-type-space').attr('checked') === 'checked') {
            typeSearch.push('"space"');
        }
        if (vSH.searchUsers || AJS.$('#content-type-user').attr('checked') === 'checked') {
            typeSearch.push('"user"');
        }
        if (vSH.searchBlogs || AJS.$('#content-type-blogpost').attr('checked') === 'checked') {
            typeSearch.push('"blogpost"');
        }
        if (vSH.searchComments || AJS.$('#content-type-comment').attr('checked') === 'checked') {
            typeSearch.push('"comment"');
        }
        if (vSH.searchAttachments || AJS.$('#content-type-attatchment').attr('checked') === 'checked') {
            typeSearch.push('"attachment"');
        }

        if (typeSearch.length >= 1) {
            var typeString = typeSearch.join(",");
            cql = cql.replace(/AND type in \(([\W*\w*]*)\)/, "AND type in (" + typeString + ")");
        }

        if (vSH.applySearchArchivedSpaces) {
            newUrl.searchParams.set("includeArchivedSpaces", vSH.searchArchivedSpaces);
        }

        newUrl.searchParams.set("cql", cql);
        url = newUrl.toString();
    }

    return oldFetch.call(this, url, options);
}
*/



AJS.toInit(function () {

    var spaceInRegex = /space\s*in\s*\((.*?)\)/;

    var contentTypeInRegex = /type\s*in\s*\((.*?)\)/;

    var spaceCategoryInRegex = /space\.category\s*in\s*\((.*?)\)/;

    function modifyOrAddSpaceParameterToCql(cql, enabledSpaceFilters, isExclude) {
        if(enabledSpaceFilters.length === 0) return cql;
        var spaceInRegexMatch = cql.match(spaceInRegex);
        var spaceKeysToJoin = [];
        var spacesInCql = spaceInRegexMatch && !isExclude ? JSON.parse("[" + spaceInRegexMatch[1].split(",") +  "]") : [];
        enabledSpaceFilters.forEach(function(spaceFilterKey) {
            spaceKeysToJoin.push(spaceFilterKey);
        })
        spacesInCql.forEach(function(spaceFilterKey) {
            spaceKeysToJoin.push(spaceFilterKey);
        })
        var newSpaceInClause = (isExclude ? "space not in" : "space in") + " (" + JSON.stringify(spaceKeysToJoin).replace(/[\[\]]/g, "") + ")"
        if(!spaceInRegexMatch) return "(" + newSpaceInClause + ")" + " AND " + cql;
        return cql.replace(spaceInRegex, newSpaceInClause)
    }

    function modifyOrAddContentTypeParameterToCql(cql, enabledSearches) {
        var contentTypeInRegexMatch = cql.match(contentTypeInRegex);
        var contentTypesToJoin = [];
        enabledSearches.forEach(function(spaceFilterKey) {
            contentTypesToJoin.push(spaceFilterKey);
        })
        var newTypeInClause = "type in (" + JSON.stringify(contentTypesToJoin).replace(/[\[\]]/g, "") + ")"
        if(!contentTypeInRegexMatch) return newTypeInClause + " AND " + cql;
        return cql.replace(contentTypeInRegex, newTypeInClause)
    }

    function modifyOrAddSpaceCategoryParameterToCql(cql, spaceCategories) {
        if(!spaceCategories || spaceCategories.length === 0) return cql;
        var contentTypesToJoin = [];
        spaceCategories.forEach(function(spaceFilterKey) {
            contentTypesToJoin.push("\"" + spaceFilterKey + "\"");
        })
        var newClause = "space.category in (" + JSON.stringify(spaceCategories).replace(/[\[\]]/g, "") + ")"
        return newClause + " AND " + cql;
    }

    var oldFetch = window.fetch;
    if (oldFetch) {
        window.fetch = function (input, init) {
            var isCallingSearchEndpoint = getIsCallingSearchEndpoint(input);
            var isPerformingSearchFromDrawer = getIsPerformingSearchFromDrawer();
            if(!isCallingSearchEndpoint || !isPerformingSearchFromDrawer) return oldFetch.call(this, input, init);
            console.log("vSH: replacing parameters", vSH);
            var newUrl = new URL(location.origin + input);

            var cql = newUrl.searchParams.get("cql");

            if (!vSH.isSearchAllSpaces) {
                var enabledSpaceFiltersCount = [];
                var disabledSpaceFiltersCount = [];
                vSH.spaceFilters.forEach(function (spaceFilter) {
                    if(spaceFilter.searchEnabled) enabledSpaceFiltersCount.push(spaceFilter.key);
                    else disabledSpaceFiltersCount.push(spaceFilter.key);
                })
                var shouldExclude = disabledSpaceFiltersCount.length < enabledSpaceFiltersCount.length
                cql = modifyOrAddSpaceParameterToCql(cql, shouldExclude ? disabledSpaceFiltersCount : enabledSpaceFiltersCount, shouldExclude);
                //newUrl.searchParams.append("spaceFilters", enabledSpaceFilters.join(","));
            }

            cql = modifyOrAddSpaceCategoryParameterToCql(cql, vSH.spaceCategories);

            if (vSH.searches) {
                var keys = Object.keys(vSH.searches);
                var enabledSearches = keys.filter(function (key) {
                        return !!vSH.searches[key];
                    }).map(function (key) {
                        return key;
                    });
                if(enabledSearches.length > 0) cql = modifyOrAddContentTypeParameterToCql(cql, enabledSearches)
                //newUrl.searchParams.append("contentTypes", keys.join(","));
            }
            newUrl.searchParams.append("currentSpaceKey", AJS.params.spaceKey);

            newUrl.searchParams.append("searchHighlighterFilter", true);

            newUrl.searchParams.set("includeArchivedSpaces", vSH.searchArchivedSpaces);

            newUrl.searchParams.set("cql", cql);

            console.log("params and init", [newUrl.searchParams, init]);

            return oldFetch.call(this, newUrl.toString(), init);
        };
    }

    function getIsPerformingSearchFromDrawer() {
        return isSearchDrawerOpen() && !vSH.isFilteringSpacesInDropdown;
    }

    function getIsCallingSearchEndpoint(url) {
        return url.indexOf("rest/api/search") > -1;
    }

    function isSearchDrawerOpen() {
        return AJS.$("[class^='SearchDrawer'] #search-filter-input").length > 0;
    }

    var baseUrl = document.getElementById('confluence-base-url').content;

    //settings changed by the user, gonna send those to the backend along with the fetch request
    var userSettings = {};

    var contentSpaceFilterInputTimeout;

    AJS.$(document).on("blur", "#content-space-filter-input", function (e) {
        console.log("blur", e);
        vSH.isFilteringSpacesInDropdown = false;
    });
    AJS.$(document).on("focus", "#content-space-filter-input", function (e) {
        console.log("focus", e);
        vSH.isFilteringSpacesInDropdown = true;
    });

    AJS.$(document).on("change", "#content-space-filter-input", function (e) {
        clearTimeout(contentSpaceFilterInputTimeout);
        AJS.$("#content-space-filter-checkbox-list #we-cant-find").remove();
        contentSpaceFilterInputTimeout = setTimeout(function () {
            if ($('#content-space-filter-checkbox-list').children(":visible").length === 0) {
                AJS.$("#content-space-filter-checkbox-list").append("<span id='we-cant-find'>We can't find anything matching your search</span>");
            }
        }, 350);
    });

    function getSearchConfiguration(currentSpaceKey, cb) {
        AJS.$.ajax({
            type: 'get',
            contentType: 'application/json',
            url: baseUrl + '/rest/vsh/1.0/settings/get?' + (!!currentSpaceKey ? "currentSpaceKey=" + currentSpaceKey : "")
        }).done(cb);
    }

    AJS.$(document).on("vSH:config-fetched", function () {
        if (vSH.isSearchAllSpaces) return;
    });

    getSearchConfiguration(AJS.params.spaceKey,function (data) {
        vSH.isAutoCompleteEnabled = data.isAutoCompleteEnabled;
        vSH.searchPages = data.searchPages;
        vSH.searchSpaces = data.searchSpaces;
        vSH.searchUsers = data.searchUsers;
        vSH.searchBlogs = data.searchBlogs;
        vSH.searchComments = data.searchComments;
        vSH.searchAttachments = data.searchAttachments;
        vSH.searchCurrentSpace = data.spaceSearchEnabled;
        vSH.searchCurrentCategory = data.categorySearchEnabled;
        vSH.spaceFilters = data.spaceFilters;
        vSH.spaceCategories = data.spaceCategories;
        vSH.isSearchAllSpaces = data.isSearchAllSpaces;
        vSH.searchArchivedSpaces = data.searchArchivedSpaces;
        vSH.searches = data.searches;
        AJS.$(document).trigger("vSH:config-fetched");
    });

    function isAnyContentTypeSetByConfiguration() {
        var keys = Object.keys(vSH.searches);
        return !!(keys.filter(function (key) {
            return !!(vSH.searches[key]);
        }));
    }

    function isContentTypeFilterDropdownShown() {
        return AJS.$("#content-type-filter-dropdown").length > 0;
    }

    function buildIgnoreableEvent(type) {
        var ignoredEvent = jQuery.Event(type);
        ignoredEvent.searchHighlighterIgnore = true;
        return ignoredEvent;
    }

    function triggerIgnoredClickEvent($el) {
        $el[0].checked = true;
        //click is problematic here
        /*if(!($el[0].checked)) {
            $el.trigger(buildIgnoreableEvent("click"));
        }*/
    }
    function selectConfiguredContentTypes() {
        if (!isAnyContentTypeSetByConfiguration()) return;
        var keys = Object.keys(vSH.searches);
        keys.forEach(function (key) {
            var $el = AJS.$("[value='" + key + "']:checkbox");
            if (AJS.$($el).length < 1) return;
            $el[0].checked = vSH.searches[key];
        });
    }

    function setSearchValue(name, value) {
        vSH.searches[name] = value;
    }

    function applyArchivedSpacesConfiguration() {
        console.log("vsh archived spaces", vSH.searchArchivedSpaces);
        if (!vSH.searchArchivedSpaces) return;
        if (!AJS.$("#search-panel-archived-spaces-toggle :checkbox").length) {
            console.log("archieved spaces toggle not here")
        }
        if (AJS.$("#search-panel-archived-spaces-toggle :checkbox").is(":checked")) {
            console.log("archieved spaces toggle already checked here")
        }
        AJS.$("#search-panel-archived-spaces-toggle :checkbox").trigger(buildIgnoreableEvent("click"));
        AJS.$("#search-panel-archived-spaces-toggle label").closest("label").attr("data-checked", "true");
    }

    function appendEnabledSpaceFiltersStyleTags(enabledSpaceFilters) {
        var $styleTag = AJS.$("<style></style>");
        AJS.$("#content-space-filter-dropdown").append($styleTag);
        enabledSpaceFilters.forEach(function (enabledSpaceFilter) {
            AJS.$($styleTag).text(AJS.$($styleTag).text() + "label[for='content-space-" + enabledSpaceFilter.key + "']{ display: none; }");
        });
        setTimeout(function(){
            AJS.$('#content-space-filter-checkbox-list .aui-nav-heading').each(function(el, ix){
                if (AJS.$(el).nextUntil("div").filter(":visible").length === 0) {
                    AJS.$(el).hide();
                }
            });
        },250);
    }

    AJS.$(document).on("click", "#vsh-content-space-filter-clear-button", function () {
        vSH.spaceFilters = vSH.spaceFilters.map(function (spaceFilter) {
            spaceFilter.searchEnabled = false;
            return spaceFilter;
        });
        AJS.$("#content-space-filter-clear-button").trigger("click");
        vSH.userSetSpaceFilters = [];
        AJS.$("#content-space-search-filter-button").trigger("click");
    });

    function doubleClickTheArchivedSpacesButton() {
        AJS.$("#search-panel-archived-spaces-toggle :checkbox").trigger(buildIgnoreableEvent("change"))
        AJS.$("#search-panel-archived-spaces-toggle :checkbox").trigger(buildIgnoreableEvent("change"))
    }

    AJS.$(document).on("click", "#vsh-content-space-filter-checkbox-list input[id*='content-space-']", function (e) {
        var spaceKey = AJS.$(this).attr("id").split("content-space-")[1];
        doubleClickTheArchivedSpacesButton();
        AJS.$("#content-space-search-filter-button").trigger(buildIgnoreableEvent("click"));
        vSH.spaceFilters = vSH.spaceFilters.map(function (spaceFilter) {
            if(spaceFilter.key === spaceKey){
                spaceFilter.searchEnabled = false;
            };
            return spaceFilter;
        });
    });

    AJS.$(document).on("click", "#content-space-filter-checkbox-list input[id*='content-space-']", function (e) {
        if (e.searchHighlighterIgnore) return;
        console.log("clicked on space (Default)", this);
        var toggled = AJS.$(this).is(":checked");
        console.log("is toggled", toggled);
        var spaceKey = AJS.$(this).attr("id").split("content-space-")[1];
        vSH.spaceFilters = vSH.spaceFilters.map(function (spaceFilter) {
            if(spaceFilter.key === spaceKey) {
                spaceFilter.searchEnabled = toggled;
                return spaceFilter;
            }
            return spaceFilter;
        });
    });

    function applySpaceFilterConfiguration() {
        if (vSH.isSearchAllSpaces) return;
        var enabledSpaceFilters = vSH.spaceFilters.filter(function (spaceFilter) {
            return spaceFilter.searchEnabled === true;
        });
        if (enabledSpaceFilters.length < 1) return;
        var $contentSpaceFilterInput = AJS.$("#content-space-filter-input");
        var $spaceFilterDummyContainer = AJS.$(vSHSoyTemplates.spaceFilterDummy({
            baseUrl: baseUrl,
            spaceFilters: enabledSpaceFilters,
            currentKey: AJS.params.spaceKey
        }));
        AJS.$($contentSpaceFilterInput).after($spaceFilterDummyContainer);
        AJS.$("#content-space-filter-dropdown").addClass("clear-button-hidden");
        appendEnabledSpaceFiltersStyleTags(enabledSpaceFilters);
    }

    function applyCategoryFilterConfiguration() {
        if (!vSH.searchCurrentCategory || !vSH.spaceCategories || !vSH.spaceCategories.length) return;
        var $categoryFilterDummyItem = AJS.$(vSHSoyTemplates.categoryFilterDummyItem({
            categories: vSH.spaceCategories.join(", ")
        }));
        console.log("appending to ", AJS.$("#space-category-filter-checkbox-list"));
        AJS.$("#space-category-filter-checkbox-list").append($categoryFilterDummyItem);
    }

    AJS.$(document).on("click", "#space-category-filter-dropdown :input[type='checkbox']", function(e){
        console.log("e", e);
        vSH.spaceCategories = [];
        if(AJS.$(e.target).is("#vsh-content-category-filter")) AJS.$("#space-category-search-filter-button").trigger(buildIgnoreableEvent("click"));
    });
/*    AJS.$(document).on("click", "#content-type-search-filter-button", function () {
        if (!isAnyContentTypeSetByConfiguration()) return;
        console.log("Content Type Filter dropdown button clicked");

        var contentTypeFilterDialogShownCheckerTimeout;
        var contentTypeFilterDialogShownChecker = function () {
            if (isContentTypeFilterDropdownShown()) {
                if (AJS.$("#content-type-filter-checkbox-list :checkbox").length > 0) {
                    selectConfiguredContentTypes();
                    return;
                }
            }//content-type-filter-checkbox-list
            contentTypeFilterDialogShownCheckerTimeout = setTimeout(contentTypeFilterDialogShownChecker, 50);
        }
        contentTypeFilterDialogShownChecker();
    });*/

    var pageMutationObserver = new MutationObserver(function (mutations, observer) {
        // look through all mutations that just occured
        mutations.forEach(function (mutation) {
            if(vSH.debugging) console.log("mutation", mutation);
            if(!!mutation.removedNodes.length && AJS.$(mutation.removedNodes[0]).is("#content-space-filter-dropdown")) {
                vSH.isFilteringSpacesInDropdown = false;
            }
            if(!mutation.addedNodes.length) return;
            if(AJS.$(mutation.addedNodes[0]).is("#content-space-filter-dropdown")) {
                console.log("mutation added space dropdown", mutation.addedNodes[0]);
                vSH.isFilteringSpacesInDropdown = true;
                applyArchivedSpacesConfiguration();
                applySpaceFilterConfiguration();
            }
            if(AJS.$(mutation.addedNodes[0]).is("#space-category-filter-dropdown")) {
                applyCategoryFilterConfiguration();
            }
            if(AJS.$(mutation.addedNodes[0]).is("#content-type-filter-dropdown")) {
                selectConfiguredContentTypes();
                AJS.$("#content-type-filter-checkbox-list input:checkbox", mutation.addedNodes[0]).on("change", function (e) {
                    console.log("Content types changed");
                    if (e.searchHighlighterIgnore) return;
                    var value = AJS.$(this).val();
                    setSearchValue(value, this.checked);
                });
            }
        });
    });


    if(!!document.getElementsByTagName("body").length) {
        pageMutationObserver.observe(document.getElementsByTagName("body")[0], {
            childList: true,
            subtree: true
        });
    }

/*    AJS.$(document).on("click", "#content-space-search-filter-button", function (e) {
        if(e.searchHighlighterIgnore) return;
        var spaceFilterDialogShownCheckerTimeout;

        var spaceFilterDialogShownChecker = function () {
            if (AJS.$("#content-space-filter-dropdown").length > 0) {
                applyArchivedSpacesConfiguration();
                applySpaceFilterConfiguration();
                return;
            }
            spaceFilterDialogShownCheckerTimeout = setTimeout(spaceFilterDialogShownChecker, 50);
        }
        spaceFilterDialogShownChecker();
    });*/

    /*AJS.$(document).on("click", "#space-category-search-filter-button", function (e) {
        if(e.searchHighlighterIgnore) return;
        console.log("clicked on dropdown");
        var categoryFilterDialogShownCheckerTimeout;

        var categoryFilterDialogShownChecker = function () {
            if (AJS.$("#space-category-filter-dropdown").length > 0) {
                applyCategoryFilterConfiguration();
                return;
            }
            categoryFilterDialogShownCheckerTimeout = setTimeout(categoryFilterDialogShownChecker, 50);
        }
        categoryFilterDialogShownChecker();
    });*/

/*    AJS.$(document).on("click", "#search-panel-archived-spaces-toggle input:checkbox", function (e) {
        if (e.searchHighlighterIgnore) return;
        console.log("toggled archived", e);
        vSH.searchArchivedSpaces = AJS.$(this).is(":checked");
        //triggerSearchOnInputElement(e);
    });*/
    AJS.$(document).on("change", "#search-panel-archived-spaces-toggle :checkbox", e => {
        if (e.searchHighlighterIgnore) return;
        console.log("toggled archived", e.target.checked);
        vSH.searchArchivedSpaces = e.target.checked;
    });


    // AJS.$(document).on("click", "#content-type-filter-checkbox-list input", function () {
    //     console.log(AJS.$(this).attr("value"));
    //     switch (AJS.$(this).attr('value')) {
    //         case "page":
    //             vSH.searchPages = AJS.$(this).attr('checked') == 'checked';
    //             break;
    //         case "space":
    //             vSH.searchSpaces = AJS.$(this).attr('checked') == 'checked';
    //             break;
    //         case "blogpost":
    //             vSH.searchBlogs = AJS.$(this).attr('checked') == 'checked';
    //             break;
    //         case "attachment":
    //             vSH.searchAttachments = AJS.$(this).attr('checked') == 'checked';
    //             break;
    //         case "comment":
    //             vSH.searchComments = AJS.$(this).attr('checked') == 'checked';
    //             break;
    //         case "user":
    //             vSH.searchUsers = AJS.$(this).attr('checked') == 'checked';
    //             break;
    //     }
    // });


    /*   AJS.$(document).on("click", "#content-type-search-filter-button", function () {

           setTimeout(function () {
               AJS.$(document).find("#content-type-page").attr('checked', vSH.searchPages);
               AJS.$(document).find("#content-type-space").attr('checked', vSH.searchSpaces);
               AJS.$(document).find("#content-type-user").attr('checked', vSH.searchUsers);
               AJS.$(document).find("#content-type-blogpost").attr('checked', vSH.searchBlogs);
               AJS.$(document).find("#content-type-comment").attr('checked', vSH.searchComments);
               AJS.$(document).find("#content-type-attachment").attr('checked', vSH.searchAttachments);
           }, 200);

       });*/
});
