var BUTLER = {} || BUTLER;
BUTLER.status = "active";
BUTLER.selection = null;
BUTLER.node = null;
BUTLER.range = null;
BUTLER.colors = [];

var obs = new MutationObserver(function (mutations, observer) {
    // look through all mutations that just occured
    mutations.forEach(function (mutation) {
        if (AJS.$(mutation.target).is("#rte-toolbar")) {
            console.log("TABLE EDITOR ROW HAS APPEARED")
            var colorButton = jQuery("#table-highlight-group button");
            console.log(colorButton);
            console.log(BUTLER.colors[0].value);
            //colorButton.attr("custom-color-value", color);
            colorButton.data("custom-color-value", BUTLER.colors[0].value);
            colorButton.find(".highlight-indicator").css("background-color", BUTLER.colors[0].value);
        }
    });
});

AJS.toInit(function () {
    function addFontColors() {
        jQuery.ajax({
            url: AJS.contextPath() + "/rest/vsh/1.0/butlerAPI/getFontColors",
            type: "POST",
            global: false,
            dataType: "text",
            contentType: "application/json",
            success: function (colors) {
                $(".color-picker-container ul").html("");
                colors = JSON.parse(colors)
                // $(document).find("click", ".color-picker-container ul").html("");
                colors.forEach(function (color) {
                    $(".color-picker-container ul")
                        .append('<li><a href="#" aria-label="' + color.name + '" data-tooltip="' + color.name + '" ' +
                            'style="background-color: ' + color.value + '" data-color="' + color.value + '" ' +
                            '>&nbsp;</a></li>'
                        )
                });
                //AJS.$(".color-picker-container ul").css("width", (colors.length * 20) + "px");
            },
            error: function (error) {

            }
        });
    }

    function addTableColors() {
        var isColorPickerRenderStart = false;

        $(function () {
            jQuery.ajax({
                url: AJS.contextPath() + "/rest/vsh/1.0/butlerAPI/getTableColors",
                type: "POST",
                global: false,
                dataType: "text",
                contentType: "application/json",
                success: function (res) {
                    colors = JSON.parse(res);
                    console.log(colors);
                    BUTLER.colors = colors;
                    var colorButton = jQuery(this).closest("#table-highlight-group").find("button");
                    //colorButton.attr("custom-color-value", color);
                    colorButton.data("custom-color-value", colors[0].value);
                    colorButton.find(".highlight-indicator").css("background-color", colors[0].value);
                    colors.push({"name": "Transparent", "value": ""});
                    var interval = setInterval(function () {
                        if ($(".table-highlight-picker").length > 0 && !isColorPickerRenderStart) {
                            isColorPickerRenderStart = true;
                            $(".table-highlight-picker").html("");
                            clearInterval(interval);
//                            console.log("START TO Crete table");
//                            $(document).find("click", ".table-highlight-picker").html("");

                            colors.forEach(function (color) {
                                $(".table-highlight-picker")
                                    .append('<li  class="veniture-custom-picker '
                                        + '"><a class="' + (color.value == '' ? ' remove-highlight ' : '') + '"'
                                        + ' data-tooltip="' + color.name + '" '
                                        + 'bg-color="' + color.value
                                        + '" style="'
                                        + (color.value != '' ? ' background-color: ' + color.value : "")
                                        + ';" href="#" class="highlight-'
                                        + color.name + '" data-highlight-colour="' + color.name + '" aria-label="' + color.name
                                        + '" original-title="' + color.name + '"></a></li>');
                            });

                            $("#rte-toolbar #table-highlight-group #table-highlight-colour .aui-dropdown")
                                .css("width", (colors.length <= 12 ? 60 :
                                    (colors.length <= 20 ? 80 :
                                        (colors.length <= 25 ? 100 :
                                            (colors.length <= 30 ? 120 :
                                                (colors.length <= 40 ? 120 : 140))))) + "px");


                        }
                    }, 400);
                },
                error: function (err) {
                    console.log(err);
                }
            });
        });
    }

    addFontColors();
    addTableColors();

    function setColor(element, color, colorName) {
        if(element.tagName != "TD" && element.tagName != "TH")
            return;
        element.class = element.tagName == "TD" ? "confluenceTd" : "confluenceTh";
        element.removeAttribute("data-highlight-colour");
        element.removeAttribute("data-mce-style");
        element.removeAttribute("title");
        //element.style = {};
        element.style.backgroundColor = color;
        setTimeout(() => {jQuery(element).attr("title", AJS.I18n.getText("net.veniture.confluence.tooltip") + " (" + colorName + ")")}, 200);

    }

    function changeTableCellColor(color, colorName) {
        if ($(document).find("#wysiwygTextarea_ifr").contents().find("td[data-mce-selected],th[data-mce-selected]").length > 0) {
            console.log("CASE 1");
            let element = $(document).find("#wysiwygTextarea_ifr").contents().find("td[data-mce-selected],th[data-mce-selected]");
           const className = element.hasClass("confluenceTd") ? "confluenceTd" : "confluenceTh";
            element.removeClass();
            element.addClass(className);
           element.removeAttr("data-highlight-colour");
           element.removeAttr("data-mce-style");
            element.css("background-color", color);
            setTimeout(() => {jQuery(element).attr("title",  AJS.I18n.getText("net.veniture.confluence.tooltip") + " (" + colorName + ")")}, 200);
        } else if (tinyMCE.activeEditor.selection.getSel() != null) {

            if (tinyMCE.activeEditor.selection.getSel().anchorNode.nodeName === "TD" || tinyMCE.activeEditor.selection.getSel().anchorNode.nodeName === "TH") {
                //console.log("CASE 2");
                setColor(tinyMCE.activeEditor.selection.getNode(), color, colorName);
            } else if (tinyMCE.activeEditor.selection.getSel().anchorNode.parentNode.nodeName === "TD" || tinyMCE.activeEditor.selection.getSel().anchorNode.parentNode.nodeName === "TH") {
                //console.log("CASE 3");
                setColor(tinyMCE.activeEditor.selection.getSel().anchorNode.parentNode, color, colorName);
            } else if (tinyMCE.activeEditor.selection.getSel().anchorNode.parentNode.nodeName === "TD" || tinyMCE.activeEditor.selection.getSel().anchorNode.parentNode.nodeName === "TH") {
                //console.log("CASE 4");
                setColor(tinyMCE.activeEditor.selection.getSel().anchorNode.parentNode, color, colorName);

            } else if (tinyMCE.activeEditor.selection.getNode().nodeName === "TD" || tinyMCE.activeEditor.selection.getNode().nodeName === "TH") {
                //console.log("CASE 5");
                setColor(tinyMCE.activeEditor.selection.getNode(), color, colorName);
            } else {
                // loop until either td found
                var tdFound = false;
                var sel = tinyMCE.activeEditor.selection.getSel().anchorNode;
                while (sel.parentNode != null && !tdFound) {
                    sel = sel.parentNode;
                    if (sel.nodeName === "TD" || sel.nodeName === "TH") {
                        //console.log("CASE 6");
                        setColor(sel, color, colorName);
                        tdFound = true;
                    }
                }

                if (!tdFound) {
                    var selectedNodes = tinyMCE.activeEditor.selection.getSelectedBlocks();
                    if (selectedNodes != null && selectedNodes.length > 0) {
                        selectedNodes.forEach(node => {
                            if (node.anchorName === "TD" || node.anchorName === "TH") {
                                setColor(node, color, colorName)
                                //node.style.backgroundColor = color;
                            }
                        });

                        /*for (var nodeIndex in selectedNodes) {
                            if (selectedNodes[nodeIndex].anchorName === "TD" || selectedNodes[nodeIndex].anchorName === "TH")
                                selectedNodes[nodeIndex].style.backgroundColor = color
                        }*/
                    }
                    setColor(BUTLER.range.startContainer.children[BUTLER.range.startOffset], color, colorName);
                    setColor(BUTLER.range.endContainer.children[BUTLER.range.endOffset], color, colorName);
                    // BUTLER.range.startContainer.children[BUTLER.range.startOffset].style.backgroundColor = color;
                    // BUTLER.range.endContainer.children[BUTLER.range.endOffset].style.backgroundColor = color;
                }
            }
        }
    }

    $(document).on("click", ".table-highlight-picker li a", function (e) {
        e.stopPropagation();
        e.preventDefault();
        var color = $(this).attr("bg-color");
        var colorName = $(this).attr("aria-label");

        var colorButton = jQuery(this).closest("#table-highlight-group").find("button");
        //colorButton.attr("custom-color-value", color);
        colorButton.data("custom-color-value", color);
        colorButton.attr("color-name", colorName);
        colorButton.find(".highlight-indicator").css("background-color", color);
        changeTableCellColor(color, colorName);
    });

    $(document).on("hover", "#table-highlight-group button", function (e) {
        BUTLER.selection = $(document).find("#wysiwygTextarea_ifr").contents().find("td[data-mce-selected],th[data-mce-selected]");
        BUTLER.node = tinyMCE.activeEditor.selection.getSel();
        BUTLER.range = tinyMCE.activeEditor.selection.getRng();
    });

    $(document).on("click", "#table-highlight-group button", function (e) {
        e.stopPropagation();
        e.preventDefault();


        var color = $(this).data("custom-color-value");
        var colorName = $(this).attr("color-name");
        changeTableCellColor(color, colorName);
    });

    obs.observe(AJS.$('body').get(0), {
        childList: true,
        subtree: true
    });
    console.log("STARTED TO OBSERVE");
});

var colors = []
//https://veniture.atlassian.net/browse/ASH-58
//commented because causes problems "net/veniture/confluence" doesn't exist, but was defined previously
/*require('confluence/module-exporter').safeRequire('net/veniture/confluence', function (ConfluencePlugin) {
    var tinymce = require('tinymce');
    tinymce.create('tinymce.plugins.veniture', ConfluencePlugin);
    tinymce.PluginManager.add('editor', tinymce.plugins.veniture);
    require('confluence-editor/loader/tinymce-bootstrap').addTinyMcePluginInit(function (settings) {
        settings.plugins += ",editor";
    });

    //todo: looks sad man :(
    //why?
});*/


