/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.searchHighlighter.servlet.filter;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import net.veniture.confluence.searchHighlighter.ao.Settings;
import net.veniture.confluence.searchHighlighter.ao.SettingsService;
import net.veniture.confluence.searchHighlighter.ao.spaces.SpaceFilter;
import net.veniture.confluence.searchHighlighter.ao.spaces.SpaceFilterDTO;
import net.veniture.confluence.searchHighlighter.ao.spaces.SpaceFilterService;
import net.veniture.confluence.searchHighlighter.license.LicenseCheckService;
import net.veniture.confluence.searchHighlighter.servlet.filter.api.ResponseWrapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchServletFilter
implements Filter {
    public static String VSH_COOKIE_USER_SETTINGS = "vSH_usersettings_";
    private static final Logger log = LoggerFactory.getLogger(SearchServletFilter.class);
    private SettingsService settingsService;
    private LicenseCheckService licenseCheckService;
    private SpaceFilterService spaceFilterService;
    private SpaceManager spaceManager;
    @ComponentImport
    private TransactionTemplate transactionTemplate;

    @Autowired
    public SearchServletFilter(TransactionTemplate transactionTemplate, LicenseCheckService licenseCheckService, SettingsService settingsService, SpaceManager spaceManager, SpaceFilterService spaceFilterService) {
        this.licenseCheckService = licenseCheckService;
        this.settingsService = settingsService;
        this.spaceFilterService = spaceFilterService;
        this.spaceManager = spaceManager;
        this.transactionTemplate = transactionTemplate;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.licenseCheckService.isLicensed() || Objects.isNull(request.getParameter("searchHighlighterFilter"))) {
            chain.doFilter(request, response);
            return;
        }
        System.out.println("Running SearchServletFilter");
        Settings settings = (Settings)this.transactionTemplate.execute(() -> this.settingsService.getSettings());
        SearchFilterRequestWrapper searchFilterRequestWrapper = new SearchFilterRequestWrapper((HttpServletRequest)request);
        searchFilterRequestWrapper.setSettings(settings);
        String searchQuery = this.extractSiteSearchClauseValuesFromParameters(searchFilterRequestWrapper);
        this.modifyContentTypesQueryString(searchFilterRequestWrapper);
        this.modifyOrderByQueryString(searchFilterRequestWrapper);
        this.modifySpaceFiltersClause(searchFilterRequestWrapper);
        this.modifySpaceCategoriesClause(searchFilterRequestWrapper);
        if (settings.isAutoCompleteEnabled()) {
            this.expandSiteSearchParameterWithAsterisk(searchFilterRequestWrapper);
        }
        this.buildQueryStringFromParameters(searchFilterRequestWrapper);
        if (StringUtils.isBlank((CharSequence)request.getCharacterEncoding())) {
            // empty if block
        }
        ResponseWrapper responseWrapper = new ResponseWrapper((HttpServletResponse)response);
        chain.doFilter((ServletRequest)searchFilterRequestWrapper, (ServletResponse)responseWrapper);
        JsonObject json = null;
        try {
            json = new JsonParser().parse(new String(responseWrapper.getCaptureAsBytes(), response.getCharacterEncoding())).getAsJsonObject();
        }
        catch (Exception e) {
            log.trace(e.getLocalizedMessage());
        }
        if (json == null) {
            response.getWriter().write(responseWrapper.getCaptureAsString());
            return;
        }
        ArrayList<JsonElement> jsonObjects = new ArrayList<JsonElement>();
        try {
            json.get("results").getAsJsonArray().forEach(jsonObjects::add);
        }
        catch (Exception e) {
            response.getOutputStream().write(responseWrapper.getCaptureAsBytes());
            return;
        }
        this.modifySearchResultsUrlKeywordQuery(jsonObjects, searchQuery);
        json.add("results", this.createJsonArrayFromList(jsonObjects));
        String out = json.toString();
        response.setContentLength(out.length());
        response.getOutputStream().write(out.getBytes(response.getCharacterEncoding()));
    }

    private static String reencode(String item) {
        byte[] bytes = item.getBytes(StandardCharsets.ISO_8859_1);
        item = new String(bytes, StandardCharsets.UTF_8);
        return item;
    }

    private void modifySearchResultsUrlKeywordQuery(List<JsonElement> jsonElements, String searchQuery) {
        jsonElements.stream().forEach(jsonElement -> {
            String currentUrl = jsonElement.getAsJsonObject().get("url").getAsString();
            try {
                jsonElement.getAsJsonObject().addProperty("url", SearchServletFilter.appendUri(currentUrl, "search=" + searchQuery).toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        });
    }

    private static URI appendUri(String uri, String appendQuery) throws URISyntaxException {
        URI oldUri = new URI(uri);
        String newQueryString = oldUri.getQuery() == null ? appendQuery : oldUri.getQuery() + "&" + appendQuery;
        return new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), new String(newQueryString.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1), oldUri.getFragment());
    }

    private JsonArray createJsonArrayFromList(List<JsonElement> list) {
        JsonArray jsonArray = new JsonArray();
        list.forEach(jsonArray::add);
        return jsonArray;
    }

    private void modifySpaceCategoriesClause(SearchFilterRequestWrapper searchFilterRequestWrapper) {
        String spaceCategories = searchFilterRequestWrapper.getParameter("spaceCategories");
        if (StringUtils.isBlank((CharSequence)spaceCategories)) {
            return;
        }
        HashSet<String> spaceCategoriesSet = new HashSet<String>(Arrays.asList(StringUtils.split((String)spaceCategories, (String)",")));
        if (spaceCategoriesSet.size() > 0) {
            this.applySpaceCategoriesToCqlQuery(spaceCategoriesSet, searchFilterRequestWrapper);
        }
    }

    private void modifySpaceFiltersClause(SearchFilterRequestWrapper searchFilterRequestWrapper) {
        HashSet<Object> spaceFilters = new HashSet();
        String spaceFiltersString = searchFilterRequestWrapper.getParameter("spaceFilters");
        if (StringUtils.isBlank((CharSequence)spaceFiltersString)) {
            return;
        }
        spaceFilters = new HashSet<String>(Arrays.asList(StringUtils.split((String)spaceFiltersString, (String)",")));
        if (spaceFilters.size() > 0) {
            this.applySpaceFiltersToCqlQuery(spaceFilters, searchFilterRequestWrapper);
        }
    }

    private boolean isSearchAllSpaces(SearchFilterRequestWrapper requestWrapper) {
        List spaceFilterDTOS = Arrays.stream(this.spaceFilterService.getAllSpaceFilters()).filter(this::doesSpaceExist).map(this::createSpaceFilterDto).collect(Collectors.toList());
        return spaceFilterDTOS.isEmpty() || spaceFilterDTOS.stream().allMatch(SpaceFilterDTO::isSearchEnabled);
    }

    private boolean doesSpaceExist(SpaceFilter spaceFilter) {
        Space space = this.spaceManager.getSpace(spaceFilter.getSearchSpace().longValue());
        return space != null && space.getKey() != null;
    }

    private SpaceFilterDTO createSpaceFilterDto(SpaceFilter spaceFilter) {
        Space space = this.spaceManager.getSpace(spaceFilter.getSearchSpace().longValue());
        SpaceFilterDTO spaceFilterDTO = new SpaceFilterDTO(space, spaceFilter.getSearchEnabled());
        return spaceFilterDTO;
    }

    private void applySpaceCategoriesToCqlQuery(Set<String> spaceFilters, SearchFilterRequestWrapper searchFilterRequestWrapper) {
        String spaceCqlClause = this.spaceFilterSetToCqlClause(spaceFilters);
        String cql = searchFilterRequestWrapper.getParameter("cql");
        Pattern p = Pattern.compile("space.category in \\(([\"\\w,\\s+]*)\\)");
        Matcher m = p.matcher(cql);
        cql = m.find() ? cql.replace(m.group(), String.format("space.category in (%s)", spaceCqlClause)) : String.format("space.category in (%s) AND ", spaceCqlClause) + cql;
        searchFilterRequestWrapper.setParameter("cql", cql);
    }

    private void applySpaceFiltersToCqlQuery(Set<String> spaceFilters, SearchFilterRequestWrapper searchFilterRequestWrapper) {
        String spaceCqlClause = this.spaceFilterSetToCqlClause(spaceFilters);
        String cql = searchFilterRequestWrapper.getParameter("cql");
        Pattern p = Pattern.compile("space in \\(([\"\\w,\\s+]*)\\)");
        Matcher m = p.matcher(cql);
        cql = m.find() ? cql.replace(m.group(), String.format("space in (%s)", spaceCqlClause)) : String.format("space in (%s) AND ", spaceCqlClause) + cql;
        searchFilterRequestWrapper.setParameter("cql", cql);
    }

    private String spaceFilterSetToCqlClause(Set<String> spaceFilters) {
        return spaceFilters.stream().map(spaceFilter -> "\"" + spaceFilter + "\"").collect(Collectors.joining(", "));
    }

    private void expandSiteSearchParameterWithAsterisk(SearchFilterRequestWrapper searchFilterRequestWrapper) {
        String cql = searchFilterRequestWrapper.getParameter("cql");
        if (StringUtils.isNotBlank((CharSequence)(cql = this.applyAsteriskRuleToQuery(cql)))) {
            searchFilterRequestWrapper.setParameter("cql", cql);
        }
    }

    private String extractSiteSearchClauseValuesFromParameters(SearchFilterRequestWrapper searchFilterRequestWrapper) {
        String reencodedCqlParameter;
        Pattern p = Pattern.compile("siteSearch ~ \"([^\"]*)\"");
        Matcher m = p.matcher(reencodedCqlParameter = searchFilterRequestWrapper.getParameter("cql"));
        if (m.find()) {
            String matchedQuery = m.group(1);
            matchedQuery = matchedQuery.replace("*", "");
            List keywords = Arrays.stream(matchedQuery.split("\\s+")).map(keyword -> keyword.replaceAll("[^a-zA-Z0-9\u00e4\u00f6\u00fc]", ",").trim()).collect(Collectors.toList());
            return String.join((CharSequence)",", keywords);
        }
        return null;
    }

    private String applyAsteriskRuleToQuery(String cql) {
        Pattern p = Pattern.compile("siteSearch ~ \"([^\"]*)\"");
        Matcher m = p.matcher(cql);
        ArrayList keywordsWithAsterisk = new ArrayList();
        if (m.find()) {
            Arrays.stream(m.group(1).split("\\.|\\s+")).filter(StringUtils::isNotBlank).map(String::trim).forEach(keyword -> {
                if (!keyword.contains("*") && !this.hasSpecialCharacters((String)keyword)) {
                    keywordsWithAsterisk.add(keyword + "*");
                }
                keywordsWithAsterisk.add(keyword);
            });
            String asteriskQuery = String.format("(%s)", keywordsWithAsterisk.stream().map(asteriskKeyword -> String.format("siteSearch ~ \"%s\"", asteriskKeyword)).collect(Collectors.joining(" OR ")));
            cql = cql.replace(m.group(), asteriskQuery);
            return cql;
        }
        return null;
    }

    private boolean hasSpecialCharacters(String keyword) {
        return keyword.chars().parallel().anyMatch(c -> Character.UnicodeBlock.of(c) != Character.UnicodeBlock.BASIC_LATIN);
    }

    private void modifyOrderByQueryString(SearchFilterRequestWrapper searchFilterRequestWrapper) {
        if (StringUtils.isBlank((CharSequence)searchFilterRequestWrapper.getSettings().getSearchResultsOrder())) {
            return;
        }
        List contentTypeResultsOrder = Arrays.stream(searchFilterRequestWrapper.getSettings().getSearchResultsOrder().split(",")).collect(Collectors.toList());
        if (contentTypeResultsOrder.isEmpty()) {
            return;
        }
        String cql = searchFilterRequestWrapper.getParameter("cql");
        if (cql.toLowerCase().contains("order by")) {
            return;
        }
        cql = cql + " order by vsh_type_order";
        searchFilterRequestWrapper.setParameter("cql", cql);
    }

    private void modifyContentTypesQueryString(SearchFilterRequestWrapper searchFilterRequestWrapper) {
        String cql = searchFilterRequestWrapper.getParameter("cql");
        String contentTypesString = searchFilterRequestWrapper.getParameter("contentTypes");
        if (StringUtils.isBlank((CharSequence)contentTypesString)) {
            return;
        }
        HashSet<String> contentTypes = new HashSet<String>(Arrays.asList(StringUtils.split((String)contentTypesString, (String)",")));
        if (contentTypes.isEmpty()) {
            return;
        }
        String contentTypesClause = String.format("type IN (%s)", contentTypes.stream().map(typeClauseKeyword -> "\"" + typeClauseKeyword + "\"").collect(Collectors.joining(",")));
        if (StringUtils.isNotBlank((CharSequence)contentTypesClause)) {
            cql = cql.replaceAll("(?<!\\.)type (IN|in) \\([\\W*\\w*]*\\)", contentTypesClause);
            searchFilterRequestWrapper.setParameter("cql", cql);
        }
    }

    private void buildQueryStringFromParameters(SearchFilterRequestWrapper searchFilterRequestWrapper) throws UnsupportedEncodingException {
        searchFilterRequestWrapper.setParameter("cql", URLEncoder.encode(searchFilterRequestWrapper.getParameter("cql"), "UTF-8"));
        searchFilterRequestWrapper.setQueryString(searchFilterRequestWrapper.getParameterMap().entrySet().stream().flatMap(paramEntrySet -> Arrays.stream((String[])paramEntrySet.getValue()).map(paramEntrySetValue -> String.format("%s=%s", paramEntrySet.getKey(), paramEntrySetValue))).collect(Collectors.joining("&")));
    }

    private String getCustomTypeClause(SearchFilterRequestWrapper searchFilterRequestWrapper) {
        String typeClause = "type IN (%s)";
        List<Object> typeClauses = new ArrayList();
        String contentTypesUserSettings = searchFilterRequestWrapper.getUserSettings().get("contentTypesSet");
        typeClauses = StringUtils.isNotBlank((CharSequence)contentTypesUserSettings) ? this.buildCustomTypeClauseFromUserSettings(searchFilterRequestWrapper) : this.buildCustomTypeClauseFromAppSettings(searchFilterRequestWrapper.getSettings());
        return String.format(typeClause, typeClauses.stream().map(typeClauseKeyword -> "\"" + typeClauseKeyword + "\"").collect(Collectors.joining(",")));
    }

    private List<String> buildCustomTypeClauseFromAppSettings(Settings settings) {
        ArrayList<String> typeClauses = new ArrayList<String>();
        HashMap typeSearches = (HashMap)new Gson().fromJson(settings.getTypeSearches(), new TypeToken<HashMap<String, Boolean>>(){}.getType());
        typeSearches.forEach((key, value) -> {
            if (value.booleanValue()) {
                typeClauses.add((String)key);
            }
        });
        return typeClauses;
    }

    private List<String> buildCustomTypeClauseFromUserSettings(SearchFilterRequestWrapper searchFilterRequestWrapper) {
        String contentTypesUserSettings = searchFilterRequestWrapper.getUserSettings().get("contentTypesSet");
        String[] contentTypesSplit = contentTypesUserSettings.split("_");
        return Arrays.stream(contentTypesSplit).map(contentTypeNameValuePair -> {
            if ("true".equals(contentTypeNameValuePair.split("-")[1])) {
                return contentTypeNameValuePair.split("-")[0];
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void modifyIncludeArchivedSpacesQueryString(SearchFilterRequestWrapper searchFilterRequestWrapper) {
        searchFilterRequestWrapper.setQueryString(searchFilterRequestWrapper.getQueryString().replace("includeArchivedSpaces=false", "includeArchivedSpaces=true"));
    }

    private boolean paramExistsInUserSettings(SearchFilterRequestWrapper searchFilterRequestWrapper, String cookieParamName) {
        return searchFilterRequestWrapper.getUserSettings().containsKey(cookieParamName);
    }

    private String getUserSetting(SearchFilterRequestWrapper searchFilterRequestWrapper, String cookieParamName) {
        return searchFilterRequestWrapper.getUserSettings().get(cookieParamName);
    }

    private boolean archivedIsSetByUser(SearchFilterRequestWrapper searchFilterRequestWrapper) {
        return this.paramExistsInUserSettings(searchFilterRequestWrapper, "archivedSet");
    }

    private boolean contentTypesSetByUser(SearchFilterRequestWrapper searchFilterRequestWrapper) {
        return this.paramExistsInUserSettings(searchFilterRequestWrapper, "contentTypesSet");
    }

    private boolean contentTypesAreConfigured(Settings settings) {
        HashMap typeSearches = (HashMap)new Gson().fromJson(settings.getTypeSearches(), new TypeToken<HashMap<String, Boolean>>(){}.getType());
        return typeSearches.entrySet().stream().anyMatch(Map.Entry::getValue);
    }

    public void modifyIncludeArchivedSpacesParam(SearchFilterRequestWrapper searchFilterRequestWrapper, Settings settings) {
        searchFilterRequestWrapper.setParameterMap((Map<String, String[]>)new HashMap<String, String[]>(searchFilterRequestWrapper.getParameterMap()){
            {
                this.put("includeArchivedSpaces", new String[]{"true"});
            }
        });
    }

    boolean isIncludeArchivedSpacesQueryParam(String queryParamName) {
        return queryParamName.equals("includeArchivedSpaces");
    }

    public void populateUserSettingsFromCookies(SearchFilterRequestWrapper searchFilterRequestWrapper) {
        HashMap<String, String> userParamsMap = new HashMap<String, String>();
        String rawCookie = searchFilterRequestWrapper.getHeader("Cookie");
        String[] rawCookieParams = rawCookie.split(";");
        Arrays.stream(rawCookieParams).filter(rawCookieParam -> rawCookieParam.split("=")[0].contains(VSH_COOKIE_USER_SETTINGS)).forEach(rawCookieParam -> {
            if (rawCookieParam.split("=").length < 2) {
                return;
            }
            try {
                userParamsMap.put(rawCookieParam.split("=")[0].trim().replace(VSH_COOKIE_USER_SETTINGS, ""), URLDecoder.decode(rawCookieParam.split("=")[1], StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage());
            }
        });
        searchFilterRequestWrapper.setUserSettings(userParamsMap);
    }

    private Cookie getConglomerateCookie(HttpServletRequest request) {
        return Arrays.stream(request.getCookies()).filter(cookie -> cookie.getName().contains("AJS.conglomerate.cookie")).findFirst().orElse(new Cookie("AJS.conglomerate.cookie", ""));
    }

    public class SearchFilterRequestWrapper
    extends HttpServletRequestWrapper {
        private Settings settings;
        private Map<String, String> userSettings;
        private Map<String, String[]> parameterMap;
        private String queryString;

        public SearchFilterRequestWrapper(HttpServletRequest request) {
            super(request);
            this.userSettings = new HashMap<String, String>();
            this.parameterMap = new HashMap<String, String[]>(request.getParameterMap());
            this.queryString = request.getQueryString();
        }

        void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public String getParameter(String name) {
            String[] results = this.parameterMap.get(name);
            if (results != null) {
                return results[0];
            }
            return null;
        }

        public void setParameter(String name, String value) {
            this.parameterMap.put(name, new String[]{value});
        }

        public ServletRequest getRequest() {
            return super.getRequest();
        }

        public String[] getParameterValues(String name) {
            return this.parameterMap.get(name);
        }

        public Map<String, String[]> getParameterMap() {
            return this.parameterMap;
        }

        void setParameterMap(Map<String, String[]> parameterMap) {
            this.parameterMap = parameterMap;
        }

        public Settings getSettings() {
            return this.settings;
        }

        void setSettings(Settings settings) {
            this.settings = settings;
        }

        public Map<String, String> getUserSettings() {
            return this.userSettings;
        }

        public void setUserSettings(Map<String, String> userSettings) {
            this.userSettings = userSettings;
        }
    }
}

