/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.searchHighlighter.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class PluginEnabledListener {
    @ComponentImport
    private EventPublisher eventPublisher;
    @ComponentImport
    private PluginAccessor pluginAccessor;
    @ComponentImport
    private PluginController pluginController;

    @Autowired
    public PluginEnabledListener(EventPublisher eventPublisher, PluginAccessor pluginAccessor, PluginController pluginController) {
        this.eventPublisher = eventPublisher;
        this.pluginAccessor = pluginAccessor;
        this.pluginController = pluginController;
    }

    @PostConstruct
    public void init() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onPluginEnabledEvent(PluginEnabledEvent pluginEnabledEvent) {
        LoggerFactory.getLogger(this.getClass()).error(pluginEnabledEvent.getPlugin().getKey());
        if (!pluginEnabledEvent.getPlugin().getKey().equals("net.veniture.confluence.vSearchHighlighter")) {
            return;
        }
        Plugin plugin = this.pluginAccessor.getPlugin("net.veniture.confluence.Butler");
        if (plugin != null) {
            this.pluginController.uninstall(plugin);
        }
    }
}

