/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.searchHighlighter.ao.spaces;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.veniture.confluence.searchHighlighter.ao.spaces.SpaceFilter;
import net.veniture.confluence.searchHighlighter.ao.spaces.SpaceFilterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class SpaceFilterServiceImpl
implements SpaceFilterService {
    Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    @ComponentImport
    private final ActiveObjects activeObjects;
    @ComponentImport
    private final SpaceManager spaceManager;

    @Autowired
    public SpaceFilterServiceImpl(ActiveObjects activeObjects, SpaceManager spaceManager) {
        this.activeObjects = activeObjects;
        this.spaceManager = spaceManager;
    }

    @Override
    public SpaceFilter[] getAllSpaceFilters() {
        SpaceFilter[] spaceFilters;
        for (SpaceFilter spaceFilter : spaceFilters = (SpaceFilter[])this.activeObjects.find(SpaceFilter.class)) {
            if (this.spaceManager.getSpace(spaceFilter.getSearchSpace().longValue()) != null) continue;
            this.deleteSpaceFilter(spaceFilter);
        }
        return spaceFilters;
    }

    @Override
    public SpaceFilter getSpaceFilter(Integer id) {
        return (SpaceFilter)this.activeObjects.get(SpaceFilter.class, (Object)id);
    }

    @Override
    public SpaceFilter getSpaceFilterBySpace(Space space) {
        try {
            return ((SpaceFilter[])this.activeObjects.find(SpaceFilter.class, Query.select().where("SEARCH_SPACE = ?", new Object[]{space.getId()})))[0];
        }
        catch (IndexOutOfBoundsException | NullPointerException ex) {
            return this.createSpaceFilter(space);
        }
    }

    @Override
    public SpaceFilter createSpaceFilter(Space space) {
        this.log.warn(space.getName() + " has not been stored yet");
        SpaceFilter spaceFilter = (SpaceFilter)this.activeObjects.create(SpaceFilter.class, new DBParam[0]);
        spaceFilter.setSearchSpace(space.getId());
        spaceFilter.setSearchEnabled(true);
        spaceFilter.save();
        return spaceFilter;
    }

    @Override
    public void deleteSpaceFilter(SpaceFilter spaceFilter) {
        this.activeObjects.delete(new RawEntity[]{spaceFilter});
    }

    @Override
    public void toggleSpaceFilter(Space space, boolean status) {
        try {
            SpaceFilter spaceFilter = ((SpaceFilter[])this.activeObjects.find(SpaceFilter.class, Query.select().where("SEARCH_SPACE = ?", new Object[]{space.getId()})))[0];
            spaceFilter.setSearchEnabled(status);
            spaceFilter.save();
        }
        catch (IndexOutOfBoundsException | NullPointerException ex) {
            SpaceFilter spaceFilter = this.createSpaceFilter(space);
            spaceFilter.setSearchEnabled(status);
        }
    }
}

