function makeHarmonyColors() {
    if(colors.length < 1) return;
    var lastColor = colors[colors.length - 1].value;
    makeHarmonyColorsTable("#grpMonochromatic", tinycolor(lastColor).monochromatic(8))
    makeHarmonyColorsTable("#grpTetrad", tinycolor(lastColor).tetrad(8))
    makeHarmonyColorsTable("#grpAnalogous", tinycolor(lastColor).analogous(8, 3))
    makeHarmonyColorsTable("#grpTriadic", tinycolor(lastColor).triad(8))
    makeHarmonyColorsTable("#grpGreyscale", [tinycolor(lastColor).greyscale()])
    makeHarmonyColorsTable("#grpComplementary", [tinycolor(lastColor).complement()])
    makeHarmonyColorsTable("#grpDarken", [tinycolor(lastColor).darken()])
    makeHarmonyColorsTable("#grpLighten", [tinycolor(lastColor).lighten()])
}

function makeHarmonyColorsTable(container, colorList) {
    jQuery(container).html("");
    jQuery.each(colorList, function (index, color) {
        var elmColor = jQuery("<div class='harmony-color' title='Click to add this color to table' color='"
            + color.toHexString()
            + "' style='background-color: "
            + color.toHexString() + "' ></div>");
        jQuery(container).append(elmColor);
    });
    jQuery(container).prepend('<h3>' + jQuery(container).attr('title') +
        '<span target-id="' + jQuery(container).attr("id")
        + '" class="aui-icon aui-icon-small aui-iconfont-add" title="Add these colors to table">Add harmony\'s colors</span></h3>'
    )
}

function getAHarmonyColor() {
    return tinycolor.random().toHexString();

}

jQuery(document).on("click", ".color-harmony h3 .aui-icon", function () {
    jQuery.each(jQuery("#" + jQuery(this).attr("target-id")).find(".harmony-color"), function () {
        colors.push({
            "name": ntc.name(jQuery(this).attr("color"))[1],
            "value": jQuery(this).attr("color")
        })
    })
    makeColorTable();
})

jQuery(document).on("click", ".harmony-color", function () {
    colors.push({
        "name": ntc.name(jQuery(this).attr("color"))[1],
        "value": jQuery(this).attr("color")
    })
    makeColorTable();
})