/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.searchHighlighter.restpoint;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.veniture.confluence.searchHighlighter.ao.Settings;
import net.veniture.confluence.searchHighlighter.ao.SettingsService;
import net.veniture.confluence.searchHighlighter.ao.spaces.SpaceFilter;
import net.veniture.confluence.searchHighlighter.ao.spaces.SpaceFilterDTO;
import net.veniture.confluence.searchHighlighter.ao.spaces.SpaceFilterService;
import net.veniture.confluence.searchHighlighter.license.LicenseCheckService;
import net.veniture.confluence.searchHighlighter.restpoint.SettingsDto;
import net.veniture.confluence.searchHighlighter.restpoint.UpdateSearchOrderRequestDataModel;
import net.veniture.confluence.searchHighlighter.restpoint.UpdateSearchesRequestDataModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/settings")
public class SettingsAPI {
    Logger log = LoggerFactory.getLogger(this.getClass());
    private final SettingsService settingsService;
    private final SpaceFilterService spaceFilterService;
    private final LicenseCheckService licenseCheckService;
    public static final String NO_LICENSE = "You have no license!";
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final LabelManager labelManager;

    @Autowired
    public SettingsAPI(SettingsService settingsService, SpaceFilterService spaceFilterService, LicenseCheckService licenseCheckService, LabelManager labelManager, SpaceManager spaceManager) {
        this.settingsService = settingsService;
        this.spaceFilterService = spaceFilterService;
        this.licenseCheckService = licenseCheckService;
        this.spaceManager = spaceManager;
        this.labelManager = labelManager;
    }

    @GET
    @Path(value="/get")
    @Produces(value={"application/json"})
    public Response getSettings(@Context HttpServletRequest request, @QueryParam(value="currentSpaceKey") String spaceKey) {
        List labels;
        if (!this.licenseCheckService.isLicensed()) {
            return Response.ok((Object)NO_LICENSE).status(401).build();
        }
        Settings settings = this.settingsService.getSettings();
        HashMap typeSearches = (HashMap)new Gson().fromJson(settings.getTypeSearches(), new TypeToken<HashMap<String, Boolean>>(){}.getType());
        ArrayList<String> contentTypeResultsOrder = StringUtils.isBlank((CharSequence)settings.getSearchResultsOrder()) ? new ArrayList<String>() : Arrays.stream(settings.getSearchResultsOrder().split(",")).collect(Collectors.toList());
        SettingsDto settingsDto = new SettingsDto(settings);
        settingsDto.setSearches(typeSearches == null ? new HashMap() : typeSearches);
        this.setSpaceFilters(settingsDto);
        settingsDto.setSearchOrder(contentTypeResultsOrder);
        settingsDto.setSearchAllSpaces(settingsDto.getSpaceFilters().isEmpty() || settingsDto.getSpaceFilters().stream().allMatch(SpaceFilterDTO::isSearchEnabled));
        if (settingsDto.isSpaceSearchEnabled() && spaceKey != null) {
            Space currentSpace = this.spaceManager.getSpace(spaceKey);
            SpaceFilterDTO currentSpaceFilterDto = new SpaceFilterDTO(currentSpace, true);
            currentSpaceFilterDto.setLogoUrl(this.spaceManager.getLogoForSpace(currentSpace.getKey()).getDownloadPath());
            settingsDto.setSpaceFilters(Collections.singletonList(currentSpaceFilterDto));
        }
        if (settingsDto.isCategorySearchEnabled() && spaceKey != null && !(labels = this.labelManager.getLabelsByDetail("", "team", spaceKey, "")).isEmpty()) {
            settingsDto.setSpaceCategories(labels.stream().map(Label::getName).collect(Collectors.toList()));
        }
        return Response.ok((Object)settingsDto).status(200).build();
    }

    private void setSpaceFilters(SettingsDto settingsDto) {
        settingsDto.setSpaceFilters(Arrays.stream(this.spaceFilterService.getAllSpaceFilters()).filter(this::doesSpaceExist).map(this::createSpaceFilterDto).collect(Collectors.toList()));
    }

    private SpaceFilterDTO createSpaceFilterDto(SpaceFilter spaceFilter) {
        Space space = this.spaceManager.getSpace(spaceFilter.getSearchSpace().longValue());
        SpaceFilterDTO spaceFilterDTO = new SpaceFilterDTO(space, spaceFilter.getSearchEnabled());
        this.setSpaceLogoUrl(spaceFilterDTO);
        return spaceFilterDTO;
    }

    private boolean doesSpaceExist(SpaceFilter spaceFilter) {
        Space space = this.spaceManager.getSpace(spaceFilter.getSearchSpace().longValue());
        return space != null && space.getKey() != null;
    }

    private void setSpaceLogoUrl(SpaceFilterDTO spaceFilterDTO) {
        spaceFilterDTO.setLogoUrl(this.spaceManager.getLogoForSpace(spaceFilterDTO.getKey()).getDownloadPath());
    }

    @GET
    @Path(value="/colors")
    @Produces(value={"application/json"})
    public Response getColors() {
        if (!this.licenseCheckService.isLicensed()) {
            return Response.ok((Object)NO_LICENSE).status(401).build();
        }
        Object[] colors = new Object[]{new Object(){
            public String name = "All results";
            public String value = SettingsAPI.access$000(SettingsAPI.this).getSettings().getInactiveTextColor();
        }, new Object(){
            public String name = "Highlighted result";
            public String value = SettingsAPI.access$000(SettingsAPI.this).getSettings().getActiveTextColor();
        }};
        return Response.ok(Arrays.stream(colors).collect(Collectors.toList())).status(200).build();
    }

    @POST
    @Path(value="/colors")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public Response updateColors(@FormParam(value="activeColor") String activeColor, @FormParam(value="inactiveColor") String inactiveColor) {
        if (!this.licenseCheckService.isLicensed()) {
            return Response.ok((Object)NO_LICENSE).status(401).build();
        }
        try {
            this.settingsService.setInactiveTextColor(inactiveColor);
            this.settingsService.setActiveTextColor(activeColor);
            return Response.ok((Object)"Colors updated").status(200).build();
        }
        catch (Exception ex) {
            return Response.ok((Object)"Something went wrong").status(301).build();
        }
    }

    @POST
    @Path(value="/autocomplete")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public Response updateAutocomplete(@FormParam(value="enableAutocomplete") String enableAutocomplete, @FormParam(value="spaces") String spaces, @FormParam(value="users") String users, @FormParam(value="pages") String pages, @FormParam(value="blogs") String blogs, @FormParam(value="comments") String comments, @FormParam(value="attachments") String attachments) {
        if (!this.licenseCheckService.isLicensed()) {
            return Response.ok((Object)NO_LICENSE).status(401).build();
        }
        try {
            this.settingsService.setAutoCompleteEnabled(enableAutocomplete.equals("true"));
            return Response.ok((Object)"Settings updated").status(200).build();
        }
        catch (Exception ex) {
            return Response.ok((Object)"Something went wrong").status(301).build();
        }
    }

    @GET
    @Path(value="/spaces")
    @Produces(value={"application/json"})
    public Response getActiveSpaces() {
        return Response.ok(Arrays.stream(this.spaceFilterService.getAllSpaceFilters()).map(spaceFilter -> {
            Space space = this.spaceManager.getSpace(spaceFilter.getSearchSpace().longValue());
            assert (space != null);
            return new SpaceFilterDTO(space, spaceFilter.getSearchEnabled());
        }).collect(Collectors.toList())).status(200).build();
    }

    @POST
    @Path(value="/searches")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response toggleSpaceSearch(UpdateSearchesRequestDataModel model) {
        if (!this.licenseCheckService.isLicensed()) {
            return Response.ok((Object)NO_LICENSE).status(401).build();
        }
        try {
            this.settingsService.setTypeSearches(new Gson().toJson(model.searches));
        }
        catch (Exception exception) {
            return Response.ok((Object)"Something went wrong! ").status(400).build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/order")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response toggleSpaceSearch(UpdateSearchOrderRequestDataModel model) {
        if (!this.licenseCheckService.isLicensed()) {
            return Response.ok((Object)NO_LICENSE).status(401).build();
        }
        try {
            if (model == null || model.order == null) {
                return Response.ok((Object)"DTO sent to REST resource is null for some reason").status(400).build();
            }
            this.settingsService.setSearchResultsOrder(String.join((CharSequence)",", model.order));
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage());
            return Response.ok((Object)"Something went wrong!").status(400).build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/space/{spaceId}/{option}")
    @Produces(value={"text/plain"})
    public Response toggleSpaceSearch(@PathParam(value="spaceId") String spaceIdText, @PathParam(value="option") String option) {
        if (!this.licenseCheckService.isLicensed()) {
            return Response.ok((Object)NO_LICENSE).status(401).build();
        }
        try {
            long spaceId = Long.parseLong(spaceIdText);
            Space space = this.spaceManager.getSpace(spaceId);
            assert (space != null);
            this.spaceFilterService.toggleSpaceFilter(space, option.equals("true"));
            return Response.ok((Object)(space.getName() + " will " + (option.equals("true") ? "" : "not ") + "be searched.")).status(200).build();
        }
        catch (Exception exception) {
            return Response.ok((Object)("Something went wrong! " + spaceIdText)).status(400).build();
        }
    }

    @POST
    @Path(value="/archivedSpaces/{option}")
    @Produces(value={"text/plain"})
    public Response toggleSearchArchivedSpaces(@PathParam(value="option") String option) {
        if (!this.licenseCheckService.isLicensed()) {
            return Response.ok((Object)NO_LICENSE).status(401).build();
        }
        try {
            boolean doSearch = option.equals("true");
            this.settingsService.setSearchArchivedSpaces(doSearch);
            return Response.ok((Object)("Archived spaces will " + (doSearch ? "" : "not ") + "be searched.")).status(200).build();
        }
        catch (Exception ex) {
            return Response.ok((Object)"Something went wrong!").status(401).build();
        }
    }

    @POST
    @Path(value="/spaceSearch/{option}")
    @Produces(value={"text/plain"})
    public Response toggleSpaceSearch(@PathParam(value="option") String option) {
        if (!this.licenseCheckService.isLicensed()) {
            return Response.ok((Object)NO_LICENSE).status(401).build();
        }
        try {
            boolean doSearch = option.equals("true");
            this.settingsService.setSpaceSearchEnabled(doSearch);
            return Response.ok((Object)"Search results will only display space results.").status(200).build();
        }
        catch (Exception ex) {
            return Response.ok((Object)"Something went wrong!").status(401).build();
        }
    }

    @POST
    @Path(value="/categorySearch/{option}")
    @Produces(value={"text/plain"})
    public Response toggleCategorySearch(@PathParam(value="option") String option) {
        if (!this.licenseCheckService.isLicensed()) {
            return Response.ok((Object)NO_LICENSE).status(401).build();
        }
        try {
            boolean doSearch = option.equals("true");
            this.settingsService.setCategorySearchEnabled(doSearch);
            return Response.ok((Object)"Search results will only display space category results.").status(200).build();
        }
        catch (Exception ex) {
            return Response.ok((Object)"Something went wrong!").status(401).build();
        }
    }

    @POST
    @Path(value="/freetext/{option}")
    @Produces(value={"text/plain"})
    public Response toggleAutocompleteSearch(@PathParam(value="option") String option) {
        if (!this.licenseCheckService.isLicensed()) {
            return Response.ok((Object)NO_LICENSE).status(401).build();
        }
        try {
            boolean doSearch = option.equals("true");
            this.settingsService.setAutoCompleteEnabled(doSearch);
            return Response.ok((Object)("Autocomplete will " + (doSearch ? "" : "not ") + "be activated.")).status(200).build();
        }
        catch (Exception ex) {
            return Response.ok((Object)"Something went wrong!").status(401).build();
        }
    }

    static /* synthetic */ SettingsService access$000(SettingsAPI x0) {
        return x0.settingsService;
    }
}

