/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.searchHighlighter.license;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import net.veniture.confluence.searchHighlighter.license.LicenseCheckService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseCheckServiceImpl
implements LicenseCheckService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @ComponentImport
    private PluginLicenseManager licenseMan;
    @ComponentImport
    private PluginAccessor pluginAccessor;

    @Autowired
    public LicenseCheckServiceImpl(PluginLicenseManager licenseMan, PluginAccessor pluginAccessor) {
        this.licenseMan = licenseMan;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public PluginLicense getLicense() {
        if (this.isLicensed()) {
            return (PluginLicense)this.licenseMan.getLicense().get();
        }
        return null;
    }

    @Override
    public boolean isLicensed() {
        if (this.isNoLicenseCheckVersion()) {
            return true;
        }
        return this.licenseMan.getLicense().isDefined() && ((PluginLicense)this.licenseMan.getLicense().get()).isValid();
    }

    private boolean isNoLicenseCheckVersion() {
        Plugin plugin = this.pluginAccessor.getPlugin(this.licenseMan.getPluginKey());
        String pluginDescription = plugin.getPluginInformation().getDescription();
        return pluginDescription.contains("V-NO-LICENSE-CHECK");
    }

    @Override
    public boolean isEvaluation() {
        return this.licenseMan.getLicense().isDefined() && ((PluginLicense)this.licenseMan.getLicense().get()).isEvaluation();
    }
}

