/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.searchHighlighter.helpers;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class Highlighter {
    private String regex;
    private String htmlContent;
    Pattern pat;
    Matcher mat;
    static Logger log = Logger.getLogger((String)"net.venITure");

    public Highlighter(String searchString, String htmlString) {
        this.regex = Highlighter.buildRegexFromQuery(searchString);
        this.htmlContent = htmlString;
        this.pat = Pattern.compile(this.regex, 66);
    }

    private boolean isWithinCodeBlock(Node node) {
        if (node.nodeName().equals("div") && node.attr("data-macro-name").contains("code")) {
            log.trace((Object)"Found Codeblock!");
            return true;
        }
        if (node != null && node.parentNode() != null) {
            return this.isWithinCodeBlock(node.parentNode());
        }
        log.trace((Object)"No parent and no codeblock");
        return false;
    }

    public String getHighlightedHtml() {
        Document doc = Jsoup.parse((String)this.htmlContent);
        final ArrayList nodesToChange = new ArrayList();
        NodeTraversor nd = new NodeTraversor(new NodeVisitor(){

            public void tail(Node node, int depth) {
                boolean containsCode = false;
                if (node.nodeName().equals("div") && node.attr("data-macro-name").contains("code")) {
                    log.trace((Object)"Yes! Found Codeblock!");
                }
                if (node instanceof TextNode) {
                    TextNode textNode = (TextNode)node;
                    String text = textNode.getWholeText();
                    Highlighter.this.mat = Highlighter.this.pat.matcher(text);
                    if (Highlighter.this.mat.find() && !Highlighter.this.isWithinCodeBlock(node)) {
                        nodesToChange.add(textNode);
                    }
                }
            }

            public void head(Node node, int depth) {
            }
        });
        nd.traverse((Node)doc.body());
        for (TextNode textNode : nodesToChange) {
            Node newNode = this.buildElementForText(textNode);
            textNode.replaceWith(newNode);
            log.trace((Object)(newNode + " newNODE"));
        }
        return doc.toString();
    }

    private static String buildRegexFromQuery(String queryString) {
        queryString = queryString.replaceAll("(^\\p{Punct}+$)*", "");
        String[] regexArray = queryString.split(" ");
        String regex = "";
        for (int i = 0; i < regexArray.length - 1; ++i) {
            String item = regexArray[i] + " ";
            regex = regex + item;
        }
        regex = regex + regexArray[regexArray.length - 1];
        return regex;
    }

    private Node buildElementForText(TextNode textNode) {
        String text = textNode.getWholeText().trim();
        ArrayList<MatchedWord> matchedWordSet = new ArrayList<MatchedWord>();
        this.mat = this.pat.matcher(text);
        while (this.mat.find()) {
            matchedWordSet.add(new MatchedWord(this.mat.start(), this.mat.end()));
        }
        StringBuffer newText = new StringBuffer(text);
        for (int i = matchedWordSet.size() - 1; i >= 0; --i) {
            String wordToReplace = newText.substring(((MatchedWord)matchedWordSet.get((int)i)).start, ((MatchedWord)matchedWordSet.get((int)i)).end);
            wordToReplace = "<vhighlight title= 'This has been highlighted as your previous search term'>" + wordToReplace + "</vhighlight>";
            newText = newText.replace(((MatchedWord)matchedWordSet.get((int)i)).start, ((MatchedWord)matchedWordSet.get((int)i)).end, wordToReplace);
        }
        return new DataNode(newText.toString(), textNode.baseUri());
    }

    class MatchedWord {
        public int start;
        public int end;

        public MatchedWord(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

