/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.searchHighlighter.search;

import com.atlassian.confluence.content.ContentTypeManager;
import com.atlassian.confluence.search.v2.HightlightParams;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.SearchDecorator;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PromoteContentTypeSearchDecorator
implements SearchDecorator {
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final ContentTypeManager contentTypeManager;

    @Autowired
    public PromoteContentTypeSearchDecorator(UserManager userManager, ContentTypeManager contentTypeManager) {
        this.userManager = Objects.requireNonNull(userManager);
        this.contentTypeManager = contentTypeManager;
    }

    public ISearch decorate(ISearch search) {
        UserKey loginUserKey = this.userManager.getRemoteUserKey();
        LoggerFactory.getLogger(this.getClass()).debug("vSH search decorating search type: " + search.getSearchType());
        if (!search.getSearchType().equals("ContentSearch")) {
            return search;
        }
        if (loginUserKey != null) {
            return new PromoteContentTypeSearch(search, loginUserKey);
        }
        return search;
    }

    private static class PromoteContentTypeSearch
    implements ISearch {
        private final ISearch delegate;
        private final UserKey creator;

        private PromoteContentTypeSearch(ISearch delegate, UserKey creator) {
            this.delegate = delegate;
            this.creator = creator;
        }

        public SearchQuery getQuery() {
            return this.delegate.getQuery();
        }

        private boolean isCustomContentType(String contentTypeName) {
            return contentTypeName.split(":").length > 1;
        }

        public SearchSort getSort() {
            return this.delegate.getSort();
        }

        public int getStartOffset() {
            return this.delegate.getStartOffset();
        }

        public int getLimit() {
            return this.delegate.getLimit();
        }

        public String getSearchType() {
            return this.delegate.getSearchType();
        }

        public Optional<HightlightParams> getHighlight() {
            return this.delegate.getHighlight();
        }

        public boolean isExplain() {
            return this.delegate.isExplain();
        }
    }
}

