/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.searchHighlighter.search;

import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.plugins.index.api.IntFieldDescriptor;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Named;
import net.veniture.confluence.searchHighlighter.ao.Settings;
import net.veniture.confluence.searchHighlighter.ao.SettingsService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class CustomOrderPropertyExtractor
implements Extractor2 {
    static final String SEARCH_FIELD_NAME = "vsh_type_order";
    static final String CONTENT_PROPERTY_NAME = "vsh_type_order";
    @ComponentImport
    private final ContentPropertyManager contentPropertyManager;
    private final SettingsService settingsService;

    @Autowired
    public CustomOrderPropertyExtractor(SettingsService settingsService, ContentPropertyManager contentPropertyManager) {
        this.settingsService = settingsService;
        this.contentPropertyManager = contentPropertyManager;
    }

    public StringBuilder extractText(Object searchable) {
        return null;
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        Settings settings = this.settingsService.getSettings();
        if (StringUtils.isBlank((CharSequence)settings.getSearchResultsOrder())) {
            return null;
        }
        List contentTypeResultsOrder = Arrays.stream(settings.getSearchResultsOrder().split(",")).collect(Collectors.toList());
        int index = 420;
        try {
            String pluginModuleKey;
            if (Arrays.asList(SpaceDescription.class, Space.class).contains(searchable.getClass())) {
                index = contentTypeResultsOrder.indexOf("space");
            } else if (Objects.equals(Page.class, searchable.getClass())) {
                index = contentTypeResultsOrder.indexOf("page");
            } else if (Objects.equals(BlogPost.class, searchable.getClass())) {
                index = contentTypeResultsOrder.indexOf("blogpost");
            } else if (Objects.equals(Comment.class, searchable.getClass())) {
                index = contentTypeResultsOrder.indexOf("comment");
            } else if (Objects.equals(PersonalInformation.class, searchable.getClass())) {
                index = contentTypeResultsOrder.indexOf("user");
            } else if (Objects.equals(Attachment.class, searchable.getClass())) {
                index = contentTypeResultsOrder.indexOf("attachment");
            } else if (searchable instanceof CustomContentEntityObject && contentTypeResultsOrder.contains(pluginModuleKey = ((CustomContentEntityObject)searchable).getPluginModuleKey())) {
                index = contentTypeResultsOrder.indexOf(pluginModuleKey);
            }
            return Collections.singletonList(new IntFieldDescriptor("vsh_type_order", index * 10, FieldDescriptor.Store.YES));
        }
        catch (Exception e) {
            return null;
        }
    }
}

