/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.searchHighlighter.decorator;

import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.search.v2.HightlightParams;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.SearchDecorator;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import java.util.Optional;
import net.veniture.confluence.searchHighlighter.ao.SettingsService;
import org.springframework.beans.factory.annotation.Autowired;

public class PromoteArchivedSpaceSearchDecorator
implements SearchDecorator {
    private SettingsService settingsService;
    @ComponentImport
    private UserManager userManager;
    @ComponentImport
    private SpaceManager spaceManager;
    @ComponentImport
    private CQLSearchService cqlSearchService;

    @Autowired
    public PromoteArchivedSpaceSearchDecorator(SettingsService settingsService, UserManager userManager, CQLSearchService searchService, SpaceManager spaceManager) {
        this.settingsService = settingsService;
        this.userManager = userManager;
        this.cqlSearchService = searchService;
        this.spaceManager = spaceManager;
    }

    public ISearch decorate(ISearch iSearch) {
        UserKey loginUserKey = this.userManager.getRemoteUserKey();
        if (loginUserKey != null) {
            return new PromoteArchivedSpaceSearch(iSearch, loginUserKey);
        }
        return iSearch;
    }

    private class PromoteArchivedSpaceSearch
    implements ISearch {
        private final ISearch delegate;
        private final UserKey creator;

        private PromoteArchivedSpaceSearch(ISearch delegate, UserKey creator) {
            this.delegate = delegate;
            this.creator = creator;
        }

        public SearchQuery getQuery() {
            return (SearchQuery)BooleanQuery.builder().addMust((Object)this.delegate.getQuery()).build();
        }

        public SearchSort getSort() {
            return this.delegate.getSort();
        }

        public int getStartOffset() {
            return this.delegate.getStartOffset();
        }

        public int getLimit() {
            return this.delegate.getLimit();
        }

        public String getSearchType() {
            return this.delegate.getSearchType();
        }

        public Optional<HightlightParams> getHighlight() {
            return this.delegate.getHighlight();
        }

        public boolean isExplain() {
            return this.delegate.isExplain();
        }
    }
}

