/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.searchHighlighter.condition;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import net.veniture.confluence.searchHighlighter.exception.NoSearchParamException;
import net.veniture.confluence.searchHighlighter.exception.NotLicensedException;
import net.veniture.confluence.searchHighlighter.license.LicenseCheckService;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchButtonEnabledCondition
extends BaseConfluenceCondition {
    private LicenseCheckService licenseCheckService;

    @Autowired
    public SearchButtonEnabledCondition(LicenseCheckService licenseCheckService) {
        this.licenseCheckService = licenseCheckService;
    }

    private void validateSearchParameterIsProvided() throws NoSearchParamException {
        String searchParameter = ServletActionContext.getRequest().getParameter("search");
        if (StringUtils.isBlank((CharSequence)searchParameter)) {
            throw NoSearchParamException.create("No search param");
        }
    }

    private void validateAppIsLicensed() throws NotLicensedException {
        if (!this.licenseCheckService.isLicensed() && !this.licenseCheckService.isEvaluation()) {
            throw NotLicensedException.create("Not licensed");
        }
    }

    protected boolean shouldDisplay(WebInterfaceContext webInterfaceContext) {
        try {
            this.validateAppIsLicensed();
            this.validateSearchParameterIsProvided();
        }
        catch (NoSearchParamException | NotLicensedException e) {
            return false;
        }
        return true;
    }
}

