AJS.$.tablesorter.addParser({
    id: 'enabled',
    is: function(nodeValue, table, cell) {
        console.log("nodeValue", nodeValue);
        console.log("cell", cell);
        if(AJS.$(cell).find("aui-toggle").length > 0) return true;
        return false;
    },
    format: function(nodeValue, table, cell) {
        console.log("nodeValue", nodeValue);
        console.log("cell", cell);
        return AJS.$(cell).find("aui-toggle")[0].checked ? 1 : 0;
    },
    type: 'numeric'
});

AJS.toInit(function () {


    function getConfiguration(cb){
        AJS.$.ajax({
            type: 'get',
            contentType: 'application/json',
            url: document.getElementById('confluence-base-url').content + '/rest/vsh/1.0/settings/get'
        }).done(function (data) {
            //console.log(data);
            cb(data);
        });
    }

    function attachContentTypeConfigurationTemplates(contentTypes){
        contentTypes.forEach(function(type){
            AJS.$("#tabs-pane-contenttype form").append(vSH.Templates.contentTypeToggle(type));
        });
    }

    function attachSearchResultsOrderConfigurationTemplates(contentTypes){
        contentTypes.forEach(function(type){
            AJS.$("#search-result-order-container").append(vSH.Templates.searchOrderItem(type));
        });

        AJS.$('#search-result-order-container').sortable({
            placeholder: "search-result-order-placeholder",
            helper:'clone',
            handle: ".handle",
            update: function(){
                var orderedIds = AJS.$("#search-result-order-container").sortable("toArray", {attribute: "data-id"});
                saveSearchOrder(orderedIds, function (){ }, function (){ });
            }
        });
    }

    function applyContentTypesConfiguration(contentTypes) {
        getConfiguration(function(vshConfig) {
            contentTypes = contentTypes.map(function(contentType) {
                contentType.checked = vshConfig.searches[contentType.type];
                return contentType;
            });
            attachContentTypeConfigurationTemplates(contentTypes);
        });
    }

    function applyTypesSearchOrderConfiguration(contentTypes){
        getConfiguration(function(vshConfig){
            contentTypes.forEach(function(contentType, ix){
                if(vshConfig.searchOrder.indexOf(contentType.type) > -1){
                    contentType.order = vshConfig.searchOrder.indexOf(contentType.type);
                } else {
                    contentType.order = 100;
                }
            });
            contentTypes.sort(function(a, b){ return (a.order > b.order) ? 1 : -1; });
            attachSearchResultsOrderConfigurationTemplates(contentTypes);
        });
    }

    getContentTypes(function(data){
        applyContentTypesConfiguration(data);
        applyTypesSearchOrderConfiguration(data);
    });

    function getContentTypes(cb) {
        //rest/cql/contenttypes?category=all
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/cql/contenttypes?category=all",
            type: "GET",
            global: false,
            dataType: "json",
            contentType: "application/json",
            success: function (data) {
                cb(data);
            }
        });
    }

    function flagAndCloseAfter(flag, timeout){
        if(!timeout) timeout = 2000;
        var flag = AJS.flag(flag);
        setTimeout(function () {
            flag.close();
        }, timeout);
    }

    AJS.$(document).on("click", "#save-color", function (event) {
        event.preventDefault();
        AJS.$.ajax({
            url: document.getElementById('confluence-base-url').content + '/rest/vsh/1.0/settings/colors',
            type: 'post',
            contentType: 'application/x-www-form-urlencoded',
            data: {
                atl_token: AJS.$('meta[name=ajs-atl-token]').attr('content'),
                inactiveColor: AJS.$('#inactiveColor').val(),
                activeColor: AJS.$('#activeColor').val()
            }
        }).done(function (data) {
            flagAndCloseAfter({
                type: 'success',
                body: 'Daten gespeichert!',
            });
        }).fail(function (jqXHR, testStatus, errorThrown) {
            flagAndCloseAfter({
                type: 'error',
                body: 'Etwas ist schief gelaufen!',
            });
        });
    });

    function saveSearchOrder(data, successCb, errorCb){
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/vsh/1.0/settings/order",
            type: 'post',
            contentType: 'application/json',
            dataType: "json",
            data: JSON.stringify({
                order: data
            })
        }).done(function (data) {
            successCb(data);
        }).fail(function (jqXHR) {
            console.log(jqXHR);
            console.log(jqXHR.status);
            if (jqXHR.status === 401) {
                flagAndCloseAfter({
                    type: 'error',
                    body: 'You have no license!'
                });
            }
            if (jqXHR.status === 400) {
                flagAndCloseAfter({
                    type: 'error',
                    body: 'Something went wrong!'
                });
            }
        });
    }

    function saveContentTypeSettings(data, successCb, errorCb){
        AJS.$.ajax({
            url: AJS.contextPath() + "/rest/vsh/1.0/settings/searches",
            type: 'post',
            contentType: 'application/json',
            dataType: "json",
            data: JSON.stringify({
                searches: data
            })
        }).done(function (data) {
            successCb(data);
        }).fail(function (jqXHR) {
            console.log(jqXHR);
            console.log(jqXHR.status);
            if (jqXHR.status === 401) {
                flagAndCloseAfter({
                    type: 'error',
                    body: 'You have no license!'
                });
            }
            if (jqXHR.status === 400) {
                flagAndCloseAfter({
                    type: 'error',
                    body: 'Something went wrong!'
                });
            }
        });
    }

    AJS.$(document).on("click", ".contenttype-checkbox", function() {
        var contentTypes = {};
        var toggle = this;

        var label = AJS.$(this).data("label");
        var isChecked = this.checked;

        toggle.busy = true;

        AJS.$("#tabs-pane-contenttype .contenttype-checkbox").each(function(ix, el){
            contentTypes[el.name] = !!el.checked;
        });

        saveContentTypeSettings(contentTypes, function(data){
            flagAndCloseAfter({
                type: 'success',
                body: label + " has been " + (isChecked ? "enabled" : "disabled")
            }, 2000);
            toggle.busy = false;
            toggle.checked = !!contentTypes[toggle.name]
        }, function(){
            toggle.busy = false;
        });
    });

/*    AJS.$(document).on("click", ".checkbox", function () {
        var toggle = AJS.$(this);
        var checked = AJS.$(this).attr('checked') == 'checked';
        var contentType = toggle.attr('id');

        toggle.busy = true;
        var url = document.getElementById('confluence-base-url').content + '/rest/vsh/1.0/settings/contentType/' + contentType + '/' + checked;
        AJS.$.ajax({
            url: url,
            type: 'post',
            contentType: 'application/x-www-form-urlencoded',
            data: {
                atl_token: AJS.$('meta[name=ajs-atl-token]').attr('content'),
            }
        }).done(function (data) {
            flagAndCloseAfter({
                type: 'success',
                body: data
            }, 2000);
        }).fail(function (jqXHR) {
            console.log(jqXHR);
            console.log(jqXHR.status);
            if (jqXHR.status === 401) {
                flagAndCloseAfter({
                    type: 'error',
                    body: 'You have no license!'
                });
            }
            if (jqXHR.status === 400) {
                flagAndCloseAfter({
                    type: 'error',
                    body: 'Something went wrong!'
                });
            }
            toggle.checked = !checked;
        }).always(function () {
            toggle.busy = false;
        });
    });*/

    AJS.$(document).on("click", "#enableCustomContentTypeSort", function () {
        var toggle = AJS.$(this);
        var checked = AJS.$(this).attr('checked') == 'checked';

        toggle.busy = true;
        var url = document.getElementById('confluence-base-url').content + '/rest/vsh/1.0/settings/customcontenttype/' + checked;
        AJS.$.ajax({
            url: url,
            type: 'post',
            contentType: 'application/x-www-form-urlencoded',
            data: {
                atl_token: AJS.$('meta[name=ajs-atl-token]').attr('content'),
            }
        }).done(function (data) {
            flagAndCloseAfter({
                type: 'success',
                body: data
            });
        }).fail(function (jqXHR) {
            console.log(jqXHR);
            console.log(jqXHR.status);
            if (jqXHR.status === 401) {
                flagAndCloseAfter({
                    type: 'error',
                    body: 'You have no license!'
                });
            }
            if (jqXHR.status === 400) {
                flagAndCloseAfter({
                    type: 'error',
                    body: 'Something went wrong!'
                });
            }

            toggle.checked = !checked;
        }).always(function () {
            toggle.busy = false;
        });
    });

    AJS.$(document).on("click", ".spaceSearch-toggle", function () {
        var toggle = AJS.$(this);
        var checked = AJS.$(this).attr('checked') == 'checked';
        var spaceId = toggle.attr('id');

        toggle.busy = true;
        var url = document.getElementById('confluence-base-url').content + '/rest/vsh/1.0/settings/space/' + spaceId + '/' + checked;
        AJS.$.ajax({
            url: url,
            type: 'post',
            contentType: 'application/x-www-form-urlencoded',
            data: {
                atl_token: AJS.$('meta[name=ajs-atl-token]').attr('content'),
            }
        }).done(function (data) {
            flagAndCloseAfter({
                type: 'success',
                body: data
            });
        }).fail(function (jqXHR) {
            console.log(jqXHR);
            console.log(jqXHR.status);
            if (jqXHR.status === 401) {
                flagAndCloseAfter({
                    type: 'error',
                    body: 'You have no license!'
                });
            }
            if (jqXHR.status === 400) {
                flagAndCloseAfter({
                    type: 'error',
                    body: 'Something went wrong!'
                });
            }

            toggle.checked = !checked;
        }).always(function () {
            toggle.busy = false;
        });
    });

    AJS.$(document).on("click", "#enableAutocomplete", function () {
        var toggle = AJS.$(this);
        var checked = AJS.$(this).attr('checked') == 'checked';

        toggle.busy = true;
        var url = document.getElementById('confluence-base-url').content + '/rest/vsh/1.0/settings/freetext/' + checked;

        AJS.$.ajax({
            url: url,
            type: 'post',
            contentType: 'application/x-www-form-urlencoded',
            data: {
                atl_token: AJS.$('meta[name=ajs-atl-token]').attr('content'),
            }
        }).done(function (data) {
            flagAndCloseAfter({
                type: 'success',
                body: data
            });
        }).fail(function (jqXHR) {
            var flag;
            console.log(jqXHR);
            console.log(jqXHR.status);
            if (jqXHR.status === 401) {
                flagAndCloseAfter({
                    type: 'error',
                    body: 'You have no license!'
                });
            }
            if (jqXHR.status === 400) {
                flagAndCloseAfter({
                    type: 'error',
                    body: 'Something went wrong!'
                });
            }

            toggle.checked = !checked;
        }).always(function () {
            toggle.busy = false;
        });
    });

    AJS.$(document).on("click", "#searchArchivedSpaces", function () {
        var toggle = AJS.$(this);
        var checked = AJS.$(this).attr('checked') == 'checked';

        toggle.busy = true;
        var url = document.getElementById('confluence-base-url').content + '/rest/vsh/1.0/settings/archivedSpaces/' + checked;

        AJS.$.ajax({
            url: url,
            type: 'post',
            contentType: 'application/x-www-form-urlencoded',
            data: {
                atl_token: AJS.$('meta[name=ajs-atl-token]').attr('content'),
            }
        }).done(function (data) {
            flagAndCloseAfter({
                type: 'success',
                body: data
            });
        }).fail(function (jqXHR) {
            var flag;
            console.log(jqXHR);
            console.log(jqXHR.status);
            if (jqXHR.status === 401) {
                flagAndCloseAfter({
                    type: 'error',
                    body: 'You have no license!'
                });
            }
            if (jqXHR.status === 400) {
                flagAndCloseAfter({
                    type: 'error',
                    body: 'Something went wrong!'
                });
            }

            toggle.checked = !checked;
        }).always(function () {
            toggle.busy = false;
        });
    });


    function callSpaceSearchAPI(toggle, name, checked) {
//            var toggle = AJS.$(this);
//            var checked = AJS.$(this).attr('checked') == 'checked';

            toggle.busy = true;
            var url = document.getElementById('confluence-base-url').content + '/rest/vsh/1.0/settings/' + name + '/' + checked;

            AJS.$.ajax({
                url: url,
                type: 'post',
                contentType: 'application/x-www-form-urlencoded',
                data: {
                    atl_token: AJS.$('meta[name=ajs-atl-token]').attr('content'),
                }
            }).done(function (data) {
                checked &&
                flagAndCloseAfter({
                    type: 'success',
                    body: data
                });
            }).fail(function (jqXHR) {
                var flag;
                console.log(jqXHR);
                console.log(jqXHR.status);
                if (jqXHR.status === 401) {
                    flagAndCloseAfter({
                        type: 'error',
                        body: 'You have no license!'
                    });
                }
                if (jqXHR.status === 400) {
                    flagAndCloseAfter({
                        type: 'error',
                        body: 'Something went wrong!'
                    });
                }

                toggle.checked = !checked;
            }).always(function () {
                toggle.busy = false;
            });
            }

    function handleSpaceSearchClick(elementName, isChecked){
        const spaceSearchToggle = AJS.$("#spaceSearch");
        const categorySearchToggle = AJS.$("#categorySearch");
        var checkStatus = {
            spaceSearch:  spaceSearchToggle.attr('checked') == 'checked',
            categorySearch: categorySearchToggle.attr('checked') == 'checked'
        };
        if(elementName == "spaceSearch") {
            checkStatus.spaceSearch = isChecked;
            if(isChecked) checkStatus.categorySearch = false;
        }
        else{
            checkStatus.categorySearch = isChecked;
            if(isChecked) checkStatus.spaceSearch = false;
        }
        callSpaceSearchAPI(spaceSearchToggle, "spaceSearch", checkStatus.spaceSearch);
        callSpaceSearchAPI(categorySearchToggle, "categorySearch", checkStatus.categorySearch);
        spaceSearchToggle.prop("checked", checkStatus.spaceSearch);
        categorySearchToggle.prop("checked", checkStatus.categorySearch);
    }

    AJS.$(document).on("click", "#spaceSearch", function () {
        var toggle = AJS.$(this);
        var checked = AJS.$(this).attr('checked') == 'checked';
        handleSpaceSearchClick("spaceSearch", checked);
    });

    AJS.$(document).on("click", "#categorySearch", function () {
        var toggle = AJS.$(this);
        var checked = AJS.$(this).attr('checked') == 'checked';
         handleSpaceSearchClick("categorySearch", checked);
    });

    // Since we added a new sorter, but the table was added at page load,
    // we'll need to kick off the sorting again.
    AJS.$('#confluence_spaces').trigger('sort');

    AJS.$(document).on("keyup", "#searchSpacesInput", function(){
        //TODO: Filter table

        var input = AJS.$(this).val();
        var rows = AJS.$('#confluence_spaces tbody tr');
        console.log(rows);
        rows.each(function (index) {
            var space = rows.get(index);
            var spaceKey = space.children[0].textContent;
            var spaceName = space.children[1].textContent;
            if(!spaceKey.toLowerCase().includes(input.toLowerCase()) && !spaceName.toLowerCase().includes(input.toLowerCase())) {
                AJS.$(this).hide();
            }else {
                AJS.$(this).show();
            }
        });
    });
});
