/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.searchHighlighter.helpers;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.transaction.Transactional;
import net.veniture.confluence.searchHighlighter.ao.SettingsService;
import net.veniture.confluence.searchHighlighter.ao.spaces.SpaceFilterDTO;
import net.veniture.confluence.searchHighlighter.ao.spaces.SpaceFilterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
@Transactional
public class SpaceFilterHelper {
    Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    @ComponentImport
    private final SpaceManager spaceManager;
    private final SpaceFilterService spaceFilterService;
    private final SettingsService settingsService;

    @Autowired
    public SpaceFilterHelper(SpaceManager spaceManager, SpaceFilterService spaceFilterService, SettingsService settingsService) {
        this.spaceManager = spaceManager;
        this.spaceFilterService = spaceFilterService;
        this.settingsService = settingsService;
    }

    public Collection<Space> getAllSpaces() {
        return this.spaceManager.getAllSpaces();
    }

    public Collection<SpaceFilterDTO> getActiveSpaces() {
        for (Space space : this.spaceManager.getAllSpaces()) {
            this.spaceFilterService.getSpaceFilterBySpace(space);
        }
        return Arrays.stream(this.spaceFilterService.getAllSpaceFilters()).filter(spaceFilter -> {
            Space space = this.spaceManager.getSpace(spaceFilter.getSearchSpace().longValue());
            return space != null && space.getKey() != null;
        }).map(spaceFilter -> {
            Space space = this.spaceManager.getSpace(spaceFilter.getSearchSpace().longValue());
            assert (space != null);
            return new SpaceFilterDTO(space, spaceFilter.getSearchEnabled());
        }).collect(Collectors.toList());
    }

    public Collection<SpaceFilterDTO> getArchivedSpaces() {
        for (Space space : this.spaceManager.getAllSpaces()) {
            this.spaceFilterService.getSpaceFilterBySpace(space);
        }
        return Arrays.stream(this.spaceFilterService.getAllSpaceFilters()).filter(spaceFilter -> {
            Space space = this.spaceManager.getSpace(spaceFilter.getSearchSpace().longValue());
            return space != null && space.getKey() != null;
        }).map(spaceFilter -> {
            Space space = this.spaceManager.getSpace(spaceFilter.getSearchSpace().longValue());
            assert (space != null);
            return new SpaceFilterDTO(space, spaceFilter.getSearchEnabled());
        }).collect(Collectors.toList());
    }
}

