/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.searchHighlighter.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.veniture.confluence.searchHighlighter.ao.Settings;
import net.veniture.confluence.searchHighlighter.ao.SettingsService;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class SettingsServiceImpl
implements SettingsService {
    @ComponentImport
    private final ActiveObjects activeObjects;

    @Autowired
    public SettingsServiceImpl(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    @Override
    public Settings getSettings() {
        try {
            return ((Settings[])this.activeObjects.find(Settings.class, Query.select()))[0];
        }
        catch (IndexOutOfBoundsException | NullPointerException i) {
            Settings settings = (Settings)this.activeObjects.create(Settings.class, new DBParam[0]);
            settings.setAutoCompleteEnabled(true);
            settings.setTypeSearches("[]");
            settings.setSearchArchivedSpaces(false);
            settings.setSearchResultsOrder("");
            settings.setActiveTextColor("#ffff00");
            settings.setInactiveTextColor("#11a1dd59");
            settings.save();
            return ((Settings[])this.activeObjects.find(Settings.class, Query.select()))[0];
        }
    }

    @Override
    public Settings[] getAllSettings() {
        return (Settings[])this.activeObjects.find(Settings.class, Query.select());
    }

    @Override
    public void setAutoCompleteEnabled(boolean autoCompleteEnabled) {
        Settings settings = this.getSettings();
        settings.setAutoCompleteEnabled(autoCompleteEnabled);
        settings.save();
    }

    @Override
    public void setTypeSearches(String typeSearches) {
        Settings settings = this.getSettings();
        settings.setTypeSearches(typeSearches);
        settings.save();
    }

    @Override
    public void setSearchResultsOrder(String searchResultsOrder) {
        Settings settings = this.getSettings();
        settings.setSearchResultsOrder(searchResultsOrder);
        settings.save();
    }

    @Override
    public void setSearchArchivedSpaces(boolean searchArchivedSpaces) {
        Settings settings = this.getSettings();
        settings.setSearchArchivedSpaces(searchArchivedSpaces);
        settings.save();
    }

    @Override
    public void setSpaceSearchEnabled(boolean spaceSearchEnabled) {
        Settings settings = this.getSettings();
        settings.setSpaceSearchEnabled(spaceSearchEnabled);
        settings.save();
    }

    @Override
    public void setCategorySearchEnabled(boolean categorySearchEnabled) {
        Settings settings = this.getSettings();
        settings.setCategorySearchEnabled(categorySearchEnabled);
        settings.save();
    }

    @Override
    public void setInactiveTextColor(String color) {
        Settings settings = this.getSettings();
        settings.setInactiveTextColor(color);
        settings.save();
    }

    @Override
    public void setActiveTextColor(String color) {
        Settings settings = this.getSettings();
        settings.setActiveTextColor(color);
        settings.save();
    }
}

