/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.pageeditorformats.api;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import net.veniture.confluence.pageeditorformats.api.AppConfigDTO;
import net.veniture.confluence.pageeditorformats.appconfig.AppConfigService;
import net.veniture.confluence.searchHighlighter.license.LicenseCheckService;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/butlerAPI")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AppAPIs {
    private final LicenseCheckService licenseCheckService;

    @Autowired
    public AppAPIs(LicenseCheckService licenseCheckService) {
        this.licenseCheckService = licenseCheckService;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/configTableColors")
    public Response configTableColors(AppConfigDTO model) {
        if (!this.licenseCheckService.isLicensed()) {
            return Response.ok((Object)"You have no license!").status(402).build();
        }
        new AppConfigService().saveTableConfiguration(model);
        return Response.ok().build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/getTableColors")
    public Response getColors() {
        if (!this.licenseCheckService.isLicensed()) {
            return Response.ok((Object)"You have no license!").status(402).build();
        }
        return Response.ok((Object)new AppConfigService().getTableColors()).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/configFontColors")
    public Response configFontColors(AppConfigDTO model) {
        if (!this.licenseCheckService.isLicensed()) {
            return Response.ok((Object)"You have no license!").status(402).build();
        }
        new AppConfigService().saveFontConfiguration(model);
        return Response.ok().build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/getFontColors")
    public Response getFontColors() {
        if (!this.licenseCheckService.isLicensed()) {
            return Response.ok((Object)"You have no license!").status(402).build();
        }
        return Response.ok((Object)new AppConfigService().getFontColors()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/getFontColors")
    public Response getGetFontColors() {
        if (!this.licenseCheckService.isLicensed()) {
            return Response.ok((Object)"You have no license!").status(402).build();
        }
        return Response.ok((Object)new AppConfigService().getFontColors()).build();
    }
}

