/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.searchHighlighter.helpers;

import javax.inject.Named;
import javax.transaction.Transactional;
import net.veniture.confluence.searchHighlighter.ao.SettingsService;
import net.veniture.confluence.searchHighlighter.license.LicenseCheckService;
import org.springframework.beans.factory.annotation.Autowired;

@Named
@Transactional
public class MyVelocityHelper {
    private final LicenseCheckService licenseCheckService;
    private final SettingsService settingsService;

    @Autowired
    public MyVelocityHelper(LicenseCheckService licenseCheckService, SettingsService settingsService) {
        this.licenseCheckService = licenseCheckService;
        this.settingsService = settingsService;
    }

    public SettingsService getSettingsService() {
        return this.settingsService;
    }

    public boolean isAutoCompleteEnabled() {
        return this.settingsService.getSettings().isAutoCompleteEnabled();
    }

    public boolean isSearchArchivedSpaces() {
        return this.settingsService.getSettings().isSearchArchivedSpaces();
    }

    public boolean isSpaceSearchEnabled() {
        return this.settingsService.getSettings().isSpaceSearchEnabled();
    }

    public boolean isCategorySearchEnabled() {
        return this.settingsService.getSettings().isCategorySearchEnabled();
    }

    public String getActiveTextColor() {
        return this.settingsService.getSettings().getActiveTextColor();
    }

    public String getInactiveTextColor() {
        return this.settingsService.getSettings().getInactiveTextColor();
    }

    public int settingsLength() {
        return this.settingsService.getAllSettings().length;
    }

    public boolean isLicensed() {
        return this.licenseCheckService.isLicensed();
    }

    public boolean isEvaluation() {
        return this.licenseCheckService.isEvaluation();
    }
}

