/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.searchHighlighter.decorator;

import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.search.v2.HightlightParams;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.ResultFilter;
import com.atlassian.confluence.search.v2.SearchDecorator;
import com.atlassian.confluence.search.v2.SearchFilter;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.searchfilter.ArchivedSpacesSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.BooleanSearchFilter;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.veniture.confluence.searchHighlighter.ao.SettingsService;
import org.springframework.beans.factory.annotation.Autowired;

public class PromoteArchivedSpaceSearchDecorator
implements SearchDecorator {
    private SettingsService settingsService;
    @ComponentImport
    private UserManager userManager;
    @ComponentImport
    private SpaceManager spaceManager;
    @ComponentImport
    private CQLSearchService cqlSearchService;

    @Autowired
    public PromoteArchivedSpaceSearchDecorator(SettingsService settingsService, UserManager userManager, CQLSearchService searchService, SpaceManager spaceManager) {
        this.settingsService = settingsService;
        this.userManager = userManager;
        this.cqlSearchService = searchService;
        this.spaceManager = spaceManager;
    }

    public ISearch decorate(ISearch iSearch) {
        UserKey loginUserKey = this.userManager.getRemoteUserKey();
        if (loginUserKey != null) {
            return new PromoteArchivedSpaceSearch(iSearch, loginUserKey);
        }
        return iSearch;
    }

    private class PromoteArchivedSpaceSearch
    implements ISearch {
        private final ISearch delegate;
        private final UserKey creator;

        private PromoteArchivedSpaceSearch(ISearch delegate, UserKey creator) {
            this.delegate = delegate;
            this.creator = creator;
        }

        public SearchQuery getQuery() {
            return (SearchQuery)BooleanQuery.builder().addMust((Object)this.delegate.getQuery()).build();
        }

        public SearchSort getSort() {
            return this.delegate.getSort();
        }

        public SearchFilter getSearchFilter() {
            SearchFilter searchFilter = this.delegate.getSearchFilter();
            if (!(searchFilter instanceof BooleanSearchFilter)) {
                return searchFilter;
            }
            CustomSearchFilter booleanSearchFilter = new CustomSearchFilter(((BooleanSearchFilter)searchFilter).getMust(), ((BooleanSearchFilter)searchFilter).getShould(), ((BooleanSearchFilter)searchFilter).getMustNot());
            return booleanSearchFilter;
        }

        public ResultFilter getResultFilter() {
            return this.delegate.getResultFilter();
        }

        public int getStartOffset() {
            return this.delegate.getStartOffset();
        }

        public int getLimit() {
            return this.delegate.getLimit();
        }

        public String getSearchType() {
            return this.delegate.getSearchType();
        }

        public Optional<HightlightParams> getHighlight() {
            return this.delegate.getHighlight();
        }

        public boolean isExplain() {
            return this.delegate.isExplain();
        }

        class CustomSearchFilter
        extends BooleanSearchFilter {
            private Collection<? extends SearchFilter> must;

            public CustomSearchFilter(Collection<? extends SearchFilter> must, Collection<? extends SearchFilter> should, Collection<? extends SearchFilter> mustNot) {
                super(must, should, mustNot);
                this.must = must;
            }

            public Set<SearchFilter> getMust() {
                HashSet<SearchFilter> mustModified = new HashSet<SearchFilter>(this.must);
                mustModified.removeIf(searchFilter1 -> searchFilter1 instanceof ArchivedSpacesSearchFilter);
                mustModified.add((SearchFilter)new ArchivedSpacesSearchFilter(true, PromoteArchivedSpaceSearchDecorator.this.spaceManager));
                return mustModified;
            }
        }
    }
}

