var DPT_HREF = {} || DPT_HREF;
DPT_HREF.replaceTitles = function (text) {
    if (text && text.length !== 0) {
        var i = text.lastIndexOf('\u2B1D');
        if (i !== -1) {
            text = text.substr(i + 2);
        }
    }
    return text;
}

DPT_HREF.obs = new MutationObserver(function (mutations, observer) {
    // look through all mutations that just occurred
    mutations.forEach(function (mutation) {
        if (mutation.addedNodes.length > 0 && (AJS.$(mutation.addedNodes[0]).is(".rw_content_list") || (AJS.$(mutation.target).is(".rw_content_list") && AJS.$(mutation.addedNodes[0]).is("li")))) {
            AJS.$('.rw_item_content', mutation.target).each(function() {
                var str = this.innerHTML;
                if(str.lastIndexOf('\u2B1D') > -1) this.innerHTML = replacePrefix(str);
            });
        }
    });
});



$(window).load(function () {
    DPT_HREF.obs.observe(AJS.$('body').get(0), {
        childList: true,
        subtree: true
    });
});