var DPT_COPY = {} || DPT_HREF;
DPT_COPY.prevent = true;

DPT_COPY.obs = new MutationObserver(function (mutations, observer) {
    // look through all mutations that just occured
    mutations.forEach(function (mutation) {
        if (AJS.$(mutation.target).is("#children")) {
            globalMoveError = true;
            DPT_COPY.dialog = AJS.$('#copy-page-hierarchy-dialog');
            if (DPT_COPY.dialog.find('#dpt-prefix--copy').length < 1) {
                DPT_COPY.addInputFieldToDialog();
            }
        }
    });
});

DPT_COPY.addInputFieldToDialog = function() {
    if (!DPT_COPY.dialog.find('fieldset.group.top-label').children().is('#dpt-prefix--copy')) {
        DPT_COPY.dialog.find('fieldset.group.top-label').prepend(
            '<div class="field-group top-label" id="dpt-prefix--copy">' +

            '<label for="title-prefix">Add hidden prefix</label>' +

            '<div class="aui-group">' +
            '<div class="aui-item">' +
            '<input class="text" type="text" id="hidden-prefix" name="hidden-prefix" autocomplete="off" maxlength="254">' +
            '</div>' +
            '<div class="aui-item">' +
            '<a class="aui-button aui-button-primary" id="add-hidden-prefix">Add prefix</a>' +
            '</div>' +
            '</div>' +
            '</div>'
        );
    }
}

$(window).load(function () {
    DPT_COPY.obs.observe(AJS.$('body').get(0), {
        childList: true,
        subtree: true
    });

    AJS.$(document).on("mousedown", "#add-hidden-prefix", function (event) {
        AJS.$('#title-prefix').val(AJS.$('#hidden-prefix').val() + " \u2B1D " + AJS.$('#title-prefix').val());
        AJS.$('#hidden-prefix').val('');
        AJS.$('#title-prefix').trigger('keyup');
        event.preventDefault();
    });
});