var DPT = {} || DPT;

DPT.logging = false; // Enable logging
DPT.prefixString = '\u2B1D';
DPT.log = function () {
    if (DPT.logging) {
        console.log.apply(console, arguments);
    }
}

//for packaging purpose

DPT.isDuplicate = false;

DPT.addPrefixPrompt;

DPT.prependParentPrefix = function () {
    var el = AJS.$("#content-title");
    var curVal = el.val();
    DPT.log(curVal);
    curVal = curVal.replace(/\[hide\].*?\[\/hide\]/g, "");
    var prependVal = AJS.$("#breadcrumbs li:last-child a").text();
    prependVal = prependVal.replace(/\[hide]/g, '').replace(/\[\/hide]/g, '');
    prependVal = prependVal + " \u2B1D ";
    el.val(prependVal + curVal);
}

DPT.showAddPrefixPrompt = function (settings) {
    DPT.addPrefixPrompt = AJS.$(
        '<section id="add-prefix-prompt" class="aui-dialog2 aui-dialog2-small aui-layer" role="dialog" aria-hidden="true">' +
        '<header class="aui-dialog2-header">' +
        '<h2 class="aui-dialog2-header-main">' + AJS.I18n.getText("net.veniture.confluence-filter.popup_title") + '</h2>' +
        '<a class="aui-dialog2-header-close">' +
        '<span class="aui-icon aui-icon-small aui-iconfont-close-dialog">' + AJS.I18n.getText("net.veniture.confluence-filter.popup_close") + '</span>' +
        '</a>' +
        '</header>' +
        '<div class="aui-dialog2-content">' +
        '<p>' + AJS.I18n.getText("net.veniture.confluence-filter.popup_first_line") + '</p>' +
        '<p>' + AJS.I18n.getText("net.veniture.confluence-filter.popup_second_line") + '</p>' +
        '</div>' +
        '<footer class="aui-dialog2-footer">' +
        '<div class="aui-dialog2-footer-actions">' +
        '<a href="javascript:void(0);" class="aui-button aui-button-primary my-confirm-button">' + AJS.I18n.getText("net.veniture.confluence-filter.popup_confirm") + '</a>' +
        '<a href="javascript:void(0);" class="aui-button aui-button-link my-cancel-button">' + AJS.I18n.getText("net.veniture.confluence-filter.popup_cancel") + '</a>' +
        '</div>' +
        '</footer>' +
        '</section>');

    AJS.dialog2(DPT.addPrefixPrompt).show();
    /*console.table({
        dialog: "Showing Dialog after prefix",
        js: "dpt.js:49"
    });*/

    AJS.dialog2(DPT.addPrefixPrompt).on("hide", function () {
        AJS.$(DPT.addPrefixPrompt).remove();
    });
    /*console.table({
        dialog: "Showing Dialog after prefix",
        js: "dpt.js:55"
    });*/

    DPT.addPrefixPrompt.on("click", ".my-cancel-button", function (e) {
        settings.onDecline();
        e.preventDefault ? e.preventDefault() : e.returnValue = false;
        return false;
    });

    DPT.addPrefixPrompt.on("click", ".my-confirm-button", function (e) {
        settings.onAccept();
        e.preventDefault ? e.preventDefault() : e.returnValue = false;
        return false;

    });
}

DPT.findPageByTitleAndKey = function (title, spaceKey, callback) {
    AJS.$.ajax({
        url: AJS.contextPath() + "/rest/api/content",
        type: 'GET',
        async: false,
        data: {
            title: title,
            spaceKey: spaceKey
        },
        global: false,
        success: function (data) {
            callback(data);
        }
    });
}

function getURLParameter(url, name) {
    return (RegExp(name + '=' + '(.+?)(&|$)').exec(url) || [, null])[1];
}

function replacePrefixInPageTree() {

    var attrTitle = AJS.$('a[title]');
    attrTitle.each(function (index, k, arr) {
        var temp = attrTitle[index];
        var str = temp.title;
        if(str.lastIndexOf('\u2B1D') === -1) return;
        str = replacePrefix(str);
        AJS.$(this).attr("title", str);
    });

    var pageLinks = AJS.$(".tree-browser-section .plugin_pagetree_children_span a, .rw_pagetree_list a, .rw_item_content, .ht-pages-nav-top a, .vertical a, .update-item-title a," +
        " .stream-item-heading, .ia-subpagetree a span:last-child, a.blogHeading, .sv-ti-title-text, a.accordion-title, .details a," +
        ".acs-side-bar-flyout-wiki-wrapper  li .label, .title a, .update-item-content a, #rw_space_news_container a, .rw_mywork_body .rw_item_content.rw_has_icon_right, .child-item a span," +
        ".ia-secondary-container.tipsy-enabled div span a, .ia-secondary-container.tipsy-enabled .label, .list-container a .item-title, #space-tools-body #tree-div li a span, " +
        ".plugin_pagetree.conf-macro.output-inline .plugin_pagetree_children_list li span a, title, #title-text a, #title-text span," +
        ".vertical .is-accordion-submenu-parent a, .vertical .is-accordion-submenu a, .ht-nav-page-link, .renderPageTree__item.undefined a," +
        ".renderPageTree__item.has-submenu-toggle a, .space-overview__hero__header__content__intro--heading.hc-spaceHome-hero-font-color," +
        "#breadcrumbs li span a"
    );
    [].forEach.call(pageLinks, function (element, k, arr) {
        var str = element.innerHTML;
        if(str.lastIndexOf('\u2B1D') > -1) element.innerHTML = replacePrefix(str);
        //this selector needs to e here
        AJS.$(".list-container-all-updates .update-item-title, .vertical .is-accordion-submenu-parent a, .vertical .is-accordion-submenu a, .ht-nav-page-link").css('visibility', 'visible');
        element.style.visibility = 'visible';
    });

}

function urlContains(url, substring) {
    return url.indexOf(substring) > -1;
}

var obs = new MutationObserver(function (mutations, observer) {
    // look through all mutations that just occured
    mutations.forEach(function (mutation) {
        DPT.log(mutation);
        //TODO: check why this is needed
        // if (mutation.type === "childList") {
        //      replacePrefixInPageTree();
        //     console.log(1);
        // }
        if (mutation.type === "childList" && AJS.$(mutation.target).is("div.rw_module_body")) {
            //uncomment to enable logging // console.log"removing prefix n das")
            AJS.$(".rw_items .rw_item_content a").each(function () {
                var str = AJS.$(this).text();
                if(str.lastIndexOf('\u2B1D') > -1) {
                    str = replacePrefix(str);
                    AJS.$(this).text(str);
                    AJS.$(this).html(str);
                }
                AJS.$(".rw_items .rw_item_content a").css('visibility', 'visible');
                /*console.table({
                    dialog: "Mutation Observer triggered",
                    js: "dpt.js:115"
                });*/
            });
        }
    });
});

var obsForRefinedPageTree = new MutationObserver(function (mutations, observer) {
    // look through all mutations that just occured
    mutations.forEach(function (mutation) {
        //uncomment to enable logging // console.logmutation);
        if (mutation.type === "childList" && AJS.$(mutation.target).is(".rw_page_tree_container")) {
            replacePrefixInPageTree();
        }
    });
});


AJS.$(document).ajaxSuccess(function (event, xhr, settings) {
    //uncomment to enable logging // console.log(settings);
    if (
        urlContains(settings.url, "rest/scroll-versions/1.0/pagetree") ||
        urlContains(settings.url, "plugins/pagetree/naturalchildren.action") ||
        urlContains(settings.url, "rest/refinedtheme/latest/page") ||
        urlContains(settings.url, "rest/api/content/search") ||
        urlContains(settings.url, "rest/scroll-viewport/1.0/tree/children") ||
        urlContains(settings.url, "rest/popular/1/stream/content") ||
        urlContains(settings.url, "rest/dashboardmacros/1.0/updates") ||
        urlContains(settings.url, "pages/children.action")
    ) {
        //uncomment to enable logging // console.log"xhr", xhr);
        //uncomment to enable logging // console.log"settings", settings);
        //uncomment to enable logging // console.log"event", event);
        setTimeout(function () {
            replacePrefixInPageTree();
        }, 300);
    }


    if (urlContains(settings.url, "rest/api/content/search")) { //this is to replace in dashboard in recently viewed pages type of view
        AJS.$(".list-container a .item-title").each(function () {
            AJS.$(this).text(replacePrefix(AJS.$(this).text()));
        });
    }

});

function replacePrefix(text) {
    if (text && text.length !== 0) {
        var i = text.lastIndexOf('\u2B1D');
        if (i !== -1) {
            text = text.substr(i + 2);
        }
    }
    return text;
}

function replacePrefixColon(text) {
    console.log("replacePrefixColon");
    if (text && text.length != 0) {
        var i = text.lastIndexOf(':');
        if (i != -1) {
            text = text.substr(i + 2);
        }
    }
    return text;
}

$(window).load(function () {
    $("header *").each(function () {
        var elements = $(this).contents()
        for (var i = 0; i < elements.length; i++) {
            var element = elements.get(i);
            if (element != null && element.nodeValue != null) {
                element.nodeValue = replacePrefix(element.nodeValue)
            }
        }
    });

    $(".space-overview *").each(function () {
        var elements = $(this).contents()
        for (var i = 0; i < elements.length; i++) {
            var element = elements.get(i);
            if (element != null && element.nodeValue != null) {
                element.nodeValue = replacePrefix(element.nodeValue)
            }
        }
    });

    $("#rw-left-column *").each(function () {
        var elements = $(this).contents()
        for (var i = 0; i < elements.length; i++) {
            var element = elements.get(i);
            if (element != null && element.nodeValue != null) {
                element.nodeValue = replacePrefix(element.nodeValue)
            }
        }
    });
});

$(window).load(function () {

    console.log("load");

    AJS.$(".update-item-title").css('visibility', 'visible');

    AJS.$(".nav-item-container-all-updates, .nav-item-container-recently-worked, .nav-item-container-recently-viewed, " +
        ".plugin_pagetree_children_span a, .tree-browser-section .plugin_pagetree_children_span a, .nav-item-container-popular-stream," +
        " a.more-link, #space-tools-body .click-zone, .collapsed, .icon.icon--expand, " +
        ".ht-sidebar-content-scroll-container .sp-toggle.sp-aui-icon-small.ht-pages-nav-toggle, .submenu-toggle").on("click", function () {
        var interval = setInterval(function () {
            replacePrefixInPageTree();
            AJS.$(".update-item-title").css('visibility', 'visible');
            AJS.$(".item-title").css('visibility', 'visible');
            AJS.$(".update-item-content a").css('visibility', 'visible');
            AJS.$("#space-tools-body #tree-div li a span").css('visibility', 'visible');
            AJS.$(".vertical .is-accordion-submenu a").css('visibility', 'visible');
            AJS.$(".vertical .is-accordion-submenu-parent a").css('visibility', 'visible');
            AJS.$(".ht-nav-page-link").css('visibility', 'visible');

        }, 100);
        setTimeout(function () {
            clearInterval(interval)
        }, 5000);
    })

    $("header *").each(function () {
        var elements = $(this).contents()
        for (var i = 0; i < elements.length; i++) {
            var element = elements.get(i);
            if (element != null && element.nodeValue != null) {
                element.nodeValue = replacePrefix(element.nodeValue)
            }
        }
    });

    $(".space-overview *").each(function () {
        var elements = $(this).contents()
        for (var i = 0; i < elements.length; i++) {
            var element = elements.get(i);
            if (element != null && element.nodeValue != null) {
                element.nodeValue = replacePrefix(element.nodeValue)
            }
        }
    });

    $("#rw-left-column *").each(function () {
        var elements = $(this).contents()
        for (var i = 0; i < elements.length; i++) {
            var element = elements.get(i);
            if (element != null && element.nodeValue != null) {
                element.nodeValue = replacePrefix(element.nodeValue)
            }
        }
    });

    // have the observer observe foo for changes in children
    var viewPortTreeList = AJS.$(".ht-pages-nav-top").get(0);

    if (viewPortTreeList) {
        obs.observe(viewPortTreeList, {
            childList: true,
            subtree: true,
            attributes: true
        });
    }

    // have the observer observe foo for changes in children
    var refinedWikiTreeList = AJS.$(".rw_pagetree_list").get(0);

    if (refinedWikiTreeList) {
        obs.observe(refinedWikiTreeList, {
            childList: true,
            subtree: true,
            attributes: true
        });
    }

    var refinedWikiLeftColumn = AJS.$("#rw_left_column").get(0);

    if (refinedWikiLeftColumn) {
        obs.observe(refinedWikiLeftColumn, {
            childList: true,
            subtree: true,
            attributes: true
        });
    }

    var refinedWikiDashboard = AJS.$(".rw_dashboard").get(0);

    if (refinedWikiDashboard) {
        obs.observe(refinedWikiDashboard, {
            childList: true,
            subtree: true,
            attributes: true
        });
    }

    var viewPortTrees = AJS.$(".renderPageTree").get();


    if (viewPortTrees.length) {
        viewPortTrees.forEach(function (element) {
            obs.observe(element, {
                childList: true,
                subtree: true,
                attributes: true
            });
        });
    }

    setTimeout(replacePrefixInPageTree, 500);

});

AJS.toInit(function () {
    console.log("init");
    /*ADPT-4,5,6,7 start*/
    var sideBarElement = AJS.$(".ia-secondary-header-title.page-tree");
    var sideBarChildElement = AJS.$(".ia-secondary-container.tipsy-enabled");
    var blogHeading = AJS.$(".blogHeading a");
    var showMore = AJS.$("a.more-link");
    var scrollViewSubmenuToggle = AJS.$(".submenu-toggle");
    var scrollViewSidebarToggle = AJS.$(".ht-sidebar-content-scroll-container .sp-toggle.sp-aui-icon-small.ht-pages-nav-toggle");
    var breadcrumbs;

    if (!!AJS.$(".sp-draft-banner").length) {
        setInterval(function () {
            replacePrefixInPageTree();
            AJS.$("a.ht-nav-page-link").css('visibility', 'visible');
        }, 200);
    }

    if (showMore !== null) {
        AJS.$(document).on("click", "a.more-link", function () {
            replacePrefixInPageTree();
            AJS.$(".update-item-content a").css('visibility', 'visible');
        })
    }

    if (blogHeading !== null) {
        replacePrefixInPageTree();
        AJS.$(".blogHeading a").css('visibility', 'visible');
    }

    if (sideBarElement !== null) {
        AJS.$(".ia-secondary-header-title.page-tree").on("click", function () {
            var interval = setInterval(function () {
                replacePrefixInPageTree();
                AJS.$(".acs-side-bar-flyout-wiki-wrapper").css('visibility', 'visible');
            }, 100);
            setTimeout(function () {
                clearInterval(interval)
            }, 500);
        })
    }

    if (sideBarChildElement !== null) {
        AJS.$(".ia-secondary-container.tipsy-enabled").on("click", function () {
            var interval = setInterval(function () {
                replacePrefixInPageTree();
                AJS.$(".acs-side-bar-flyout-wiki-wrapper").css('visibility', 'visible');
            }, 100);
            setTimeout(function () {
                clearInterval(interval)
            }, 500);
        })
    }

    if (scrollViewSidebarToggle !== null) {
        AJS.$(".ht-sidebar-content-scroll-container .sp-toggle.sp-aui-icon-small.ht-pages-nav-toggle").on("click", function () {
            var interval = setInterval(function () {
                replacePrefixInPageTree();
            }, 100);
            setTimeout(function () {
                clearInterval(interval)
            }, 500);
        })
    }

    if (scrollViewSubmenuToggle !== null) {
        AJS.$(".submenu-toggle").on("click", function () {
            var interval = setInterval(function () {
                replacePrefixInPageTree();
            }, 100);
            setTimeout(function () {
                clearInterval(interval)
            }, 500);
        })
    }
    /*ADPT-4 stop*/

    (function () {
        AJS.$("#welcome-message p a").each(function (i, obj) {
            AJS.$(this).text(replacePrefix(AJS.$(this).text()));
        });
    })();

    if (document.title !== null) {
        document.title = replacePrefix(document.title);
    }


    /*AJS.$("#ht-post-nav a span").each(function(){
        var str = AJS.$(this).text();
        str = replacePrefix(str);
        AJS.$(this).text(str);
    });*/

    AJS.$(".breadcrumbs--active").each(function () {
        var str = AJS.$(this).text();
        str = replacePrefixColon(str);
        AJS.$(this).text(str);
    });

    AJS.$("#ht-breadcrumb a, .ht-content-header h1, #ht-post-nav a span, .update-item-content a, .cell.grid-x h1, .cell.grid-x a, " +
        ".breadcrumbs--active, .childpages-macro a, .conf-macro h1 a, .conf-macro h2 a, .conf-macro h3 a, .conf-macro h4 a, .conf-macro h5 a, " +
        ".conf-macro h6 a").each(function () {
        var str = AJS.$(this).text();
        str = replacePrefix(str);
        AJS.$(this).text(str);
    });

    if ($(".sv-breadcrumb").length > 0) {
        var anchorText = AJS.$(".sv-breadcrumb").last().find("a").text();
        AJS.$(".sv-breadcrumb").last().find("a").text(replacePrefix(anchorText));
    } else {
        var anchorText = jQuery("#breadcrumbs").find("a").last().text();
        jQuery("#breadcrumbs").find("a").last().text(replacePrefix(anchorText));
    }

    AJS.$(document).ajaxError(function (event, jqxhr, settings, thrownError) {
        var methodType = settings.type.toLowerCase();
        const isContentEndpoint = settings.url.indexOf("rest/api/content") > -1;
        const isUpdateMethod = methodType === "put" || methodType === "post";
        if(!(isContentEndpoint && isUpdateMethod)) return;
       // console.log"jqxhr", jqxhr);  //uncomment to enable logging
         // console.log"settings", settings); //uncomment to enable logging
        var responseText = jqxhr.responseText.toLowerCase();
        var isDuplicateError = responseText.indexOf("title") > -1 && responseText.indexOf("already") > -1 && responseText.indexOf("exists") > -1;

        if (!isDuplicateError) return;
        DPT.showAddPrefixPrompt({
            onDecline: function () {
                AJS.dialog2(DPT.addPrefixPrompt).remove();
            },
            onAccept: function () {
                AJS.dialog2(DPT.addPrefixPrompt).remove();
                DPT.prependParentPrefix();
            }
        });
    });

    (function () {
        var errorMessage = AJS.$("#all-messages > div.aui-message.aui-message-error.closeable");
        if (AJS.$(errorMessage).length < 1) return;
        if (AJS.$(errorMessage).find("li").length > 0 &&
            AJS.$(errorMessage).find("li").html().indexOf("already") > 0 &&
            AJS.$(errorMessage).find("li").html().indexOf("exists") > 0 &&
            AJS.$(errorMessage).find("li").html().indexOf("title") > 0) {
            DPT.showAddPrefixPrompt({
                onDecline: function () {
                    AJS.dialog2(DPT.addPrefixPrompt).remove();
                },
                onAccept: function () {
                    AJS.dialog2(DPT.addPrefixPrompt).remove();
                    DPT.prependParentPrefix();
                }
            });
        }
    })();


    (function () {
        AJS.$("#main-content a").each(function (i, obj) {
            if (!AJS.$(this).has('img') && !AJS.$(this).hasClass('external-link') && !AJS.$(this).hasClass('userLogoLink')) {
                if (AJS.$(obj).text() !== null) {
                    AJS.$(obj).text(replacePrefix(AJS.$(obj).text()));
                }
            }
        });
    })();

    AJS.$.ajaxPrefilter(function (options, originalOptions, jqXHR) {
        if (originalOptions != null &&
            originalOptions.url != null &&
            originalOptions.url.indexOf("/pages/breadcrumb.action") > -1 &&
            originalOptions.type == "GET") {
            if (originalOptions.data.title !== undefined && originalOptions.data.title.indexOf("⬝") > -1) {
                var pageId;
                var pageTitle = originalOptions.data.title;
                var spaceKey = originalOptions.data.spaceKey;
                if (AJS.$(".location-panel").is(":visible")) {
                    //uncomment to enable logging // console.log"location-panel open");
                    DPT.findPageByTitleAndKey(AJS.$("#new-parent-page").val(), AJS.params.spaceKey, function (data) {
                        //uncomment to enable logging // console.logdata);
                        if (data.size > 0) {
                            pageId = data.results[0].id;
                        }
                    });
                } else if (AJS.$(".browse-panel").is(":visible")) {
                    //uncomment to enable logging // console.log"browse-panel open");
                    pageId = AJS.$(".page-node.highlighted").parent().attr("id").split("-")[1];
                } else if (AJS.$(".search-panel").is(":visible")) {
                    //uncomment to enable logging // console.log"search-panel open");
                    var rowAnchorHref = AJS.$(".search-result.selected").find("a").attr("href");
                    //uncomment to enable logging // console.logrowAnchorHref);
                    pageId = getURLParameter(rowAnchorHref, "pageId");
                    //uncomment to enable logging // console.logpageId);
                } else {
                    //uncomment to enable logging // console.log"None open");
                }
                if (pageId == null) {
                    options.url = originalOptions.url + "?" + AJS.$.param({
                        spaceKey: spaceKey,
                        title: pageTitle
                    });
                } else {
                    options.url = originalOptions.url + "?" + AJS.$.param({
                        spaceKey: spaceKey,
                        pageId: pageId
                    });
                }
            }
        }
    });

});
