/*
 * Decompiled with CFR 0.152.
 */
package net.veniture.confluence.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.veniture.confluence.filter.utils.ResponseWrapper;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewportFilter
implements Filter {
    public final String REGEX = "([^>^\"^:]*) (\u2b1d) ";
    Logger log = LoggerFactory.getLogger(this.getClass());
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ResponseWrapper wrappedResponse = new ResponseWrapper((HttpServletResponse)response);
        HttpServletRequest req = (HttpServletRequest)request;
        if (!this.isRequestForConfluence(req)) {
            this.log.trace("Viewport request filter");
            try {
                chain.doFilter(request, (ServletResponse)wrappedResponse);
                PrintWriter respStream = response.getWriter();
                String out = ((Object)((Object)wrappedResponse)).toString();
                if (out.contains("\u2b1d")) {
                    out = out.replaceAll("([^>^\"^:]*) (\u2b1d) ", "");
                    this.log.trace("venITure was here");
                    Document doc = Jsoup.parse(out);
                    doc.getElementsContainingOwnText("\u2b1d").forEach(e -> {
                        this.log.trace(e.text());
                        String orig = e.text();
                        e.text(orig.replaceAll("([^>^\"^:]*) (\u2b1d) ", ""));
                    });
                    Element scrollPageContext = doc.selectFirst("#sv-scroll-page-context");
                    if (Objects.nonNull(scrollPageContext)) {
                        String scrollPageContextJson = scrollPageContext.attr("content");
                        scrollPageContext.attr("content", scrollPageContextJson.replaceAll("([^>^\"^:]*) (\u2b1d) ", ""));
                        this.log.trace(scrollPageContextJson.toString() + "JSON");
                    }
                    out = doc.toString();
                }
                respStream.write(out);
                return;
            }
            catch (Exception e2) {
                this.log.warn(e2.getMessage());
                this.log.error("venITure: No valid license");
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public boolean isConfluenceRequest(String url) {
        url = StringUtils.defaultString((String)url);
        this.log.trace(url + " url");
        if (url.contains("/admin") || url.contains("/ajax") || url.contains("/display") || url.contains("/download") || url.contains("/images") || url.contains("/includes") || url.contains("/json") || url.contains("/plugins") || url.contains("/pages") || url.contains("/label") || url.contains("/jcaptcha") || url.contains("/rest") || url.contains("/s/") || url.contains("/x/") || url.contains("/spaces") || url.contains("/styles") || url.contains("/rpc") || url.contains("/files") || url.contains("/500page.jsp") || url.contains("ico") || url.contains("/noop.jsp") || url.contains("/login.action") || url.contains(".action") || url.contains("/longrunningtaskxml.action") || url.contains("/attachments") || url.equals("/")) {
            return true;
        }
        this.log.trace("No Confluence Page");
        return false;
    }

    public String replaceDuplicateSlashes(String fullPath) {
        return fullPath.replaceAll("/{2,}", "/");
    }

    public String getPathWithoutWebAppContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        URL fullURL = this.getFullURL(request);
        return StringUtils.isBlank((CharSequence)contextPath) ? fullURL.getPath() : this.stripContextPath(fullURL.getPath(), contextPath);
    }

    private boolean isRequestForConfluence(HttpServletRequest request) {
        String url = this.replaceDuplicateSlashes(this.getPathWithoutWebAppContextPath(request));
        return this.isConfluenceRequest(url);
    }

    public String getFullUrlString(HttpServletRequest request) {
        try {
            return request.getQueryString() != null ? request.getRequestURL().toString() + "?" + request.getQueryString() : request.getRequestURL().toString();
        }
        catch (NullPointerException e) {
            this.log.warn(e.getMessage());
            return "";
        }
    }

    public URL getFullURL(HttpServletRequest request) {
        try {
            return new URL(this.getFullUrlString(request));
        }
        catch (MalformedURLException e) {
            this.log.warn(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private String stripContextPath(String fullPath, String contextPath) {
        this.log.trace(fullPath + contextPath + " FULL + Context");
        return StringUtils.removeStart((String)fullPath, (String)contextPath);
    }
}

